/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import java.nio.FloatBuffer;
import net.optifine.shaders.uniform.ShaderUniformBase;
import net.optifine.util.BufferUtil;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.system.MemoryUtil;

public class ShaderUniformM4
extends ShaderUniformBase {
    private boolean transpose;
    private FloatBuffer matrixBuffer = MemoryUtil.memAllocFloat((int)16);
    private FloatBuffer tempBuffer = MemoryUtil.memAllocFloat((int)16);

    public ShaderUniformM4(String name) {
        super(name);
    }

    public void setValue(d matrixIn) {
        this.transpose = false;
        this.tempBuffer.clear();
        matrixIn.c(this.tempBuffer);
        this.setValue(false, this.tempBuffer);
    }

    public void setValue(boolean transpose, FloatBuffer matrix) {
        this.transpose = transpose;
        this.matrixBuffer.clear();
        this.matrixBuffer.put(matrix);
        this.matrixBuffer.rewind();
        int location = this.getLocation();
        if (location < 0) {
            return;
        }
        ShaderUniformM4.flushRenderBuffers();
        ARBShaderObjects.glUniformMatrix4fvARB((int)location, (boolean)transpose, (FloatBuffer)this.matrixBuffer);
        this.checkGLError();
    }

    public float getValue(int row, int col) {
        int index = this.transpose ? col * 4 + row : row * 4 + col;
        float value = this.matrixBuffer.get(index);
        return value;
    }

    @Override
    protected void onProgramSet(int program) {
    }

    @Override
    protected void resetValue() {
        BufferUtil.fill(this.matrixBuffer, 0.0f);
    }
}

