/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.optifine.config.BiomeId;
import net.optifine.override.ChunkCacheOF;

public class BiomeUtils {
    private static gw<bxo> biomeRegistry = BiomeUtils.getBiomeRegistry((bwp)dvo.C().s);
    public static bxo PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, (wv<bxo>)bxu.b, () -> ln.a((boolean)false));
    public static bxo SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, (wv<bxo>)bxu.g, () -> ln.d((float)-0.2f, (float)0.1f, (boolean)false));
    public static bxo SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, (wv<bxo>)bxu.af, () -> ln.d((float)-0.1f, (float)0.3f, (boolean)true));

    public static void onWorldChanged(bwp worldIn) {
        biomeRegistry = BiomeUtils.getBiomeRegistry(worldIn);
        PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, (wv<bxo>)bxu.b, () -> ln.a((boolean)false));
        SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, (wv<bxo>)bxu.g, () -> ln.d((float)-0.2f, (float)0.1f, (boolean)false));
        SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, (wv<bxo>)bxu.af, () -> ln.d((float)-0.1f, (float)0.3f, (boolean)true));
    }

    private static bxo getBiomeSafe(gw<bxo> registry, wv<bxo> biomeKey, Supplier<bxo> biomeDefault) {
        bxo biome = (bxo)registry.a(biomeKey);
        if (biome == null) {
            biome = biomeDefault.get();
        }
        return biome;
    }

    public static gw<bxo> getBiomeRegistry(bwp worldIn) {
        if (worldIn != null) {
            return worldIn.t().b(gw.aO);
        }
        return ib.i;
    }

    public static gw<bxo> getBiomeRegistry() {
        return biomeRegistry;
    }

    public static ww getLocation(bxo biome) {
        return BiomeUtils.getBiomeRegistry().b((Object)biome);
    }

    public static int getId(bxo biome) {
        return BiomeUtils.getBiomeRegistry().a((Object)biome);
    }

    public static int getId(ww loc) {
        bxo biome = BiomeUtils.getBiome(loc);
        return BiomeUtils.getBiomeRegistry().a((Object)biome);
    }

    public static BiomeId getBiomeId(ww loc) {
        return BiomeId.make(loc);
    }

    public static bxo getBiome(ww loc) {
        return (bxo)BiomeUtils.getBiomeRegistry().a(loc);
    }

    public static Set<ww> getLocations() {
        return BiomeUtils.getBiomeRegistry().c();
    }

    public static List<bxo> getBiomes() {
        return Lists.newArrayList(biomeRegistry);
    }

    public static List<BiomeId> getBiomeIds() {
        return BiomeUtils.getBiomeIds(BiomeUtils.getLocations());
    }

    public static List<BiomeId> getBiomeIds(Collection<ww> locations) {
        ArrayList<BiomeId> biomeIds = new ArrayList<BiomeId>();
        for (ww loc : locations) {
            BiomeId bi = BiomeId.make(loc);
            if (bi == null) continue;
            biomeIds.add(bi);
        }
        return biomeIds;
    }

    public static bxo getBiome(bvr lightReader, gg blockPos) {
        bxo biome = PLAINS;
        if (lightReader instanceof ChunkCacheOF) {
            biome = ((ChunkCacheOF)lightReader).getBiome(blockPos);
        } else if (lightReader instanceof bws) {
            biome = ((bws)lightReader).w(blockPos);
        }
        return biome;
    }
}

