/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.optifine.Config;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(cks blockStateIn, bvt blockReaderIn, gg blockPosIn, gl facingIn, RenderEnv renderEnv) {
        gg posNeighbour = blockPosIn.a(facingIn);
        cks stateNeighbour = blockReaderIn.a_(posNeighbour);
        if (stateNeighbour.isCacheOpaqueCube()) {
            return false;
        }
        if (blockStateIn.a(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.l()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(cks blockStateIn, bvt blockReaderIn, gg blockPosIn, gl facingIn, RenderEnv renderEnv, cks stateNeighbourIn, gg posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        dnt voxelshape = blockStateIn.a(blockReaderIn, blockPosIn, facingIn);
        if (voxelshape.b()) {
            return true;
        }
        dnt voxelshape1 = stateNeighbourIn.a(blockReaderIn, posNeighbourIn, facingIn.f());
        boolean flag = dnq.c((dnt)voxelshape, (dnt)voxelshape1, (dne)dne.e);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(bzo block) {
        return gw.W.a((Object)block);
    }

    public static bzo getBlock(ww loc) {
        if (!gw.W.c(loc)) {
            return null;
        }
        return (bzo)gw.W.a(loc);
    }

    public static int getMetadata(cks blockState) {
        bzo block = blockState.b();
        ckt stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(bzo block) {
        ckt stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        return validStates.size();
    }

    public static cks getBlockState(bzo block, int metadata) {
        ckt stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        cks blockState = (cks)validStates.get(metadata);
        return blockState;
    }

    public static List<cks> getBlockStates(bzo block) {
        ckt stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        return validStates;
    }

    public static boolean isFullCube(cks stateIn, bvt blockReaderIn, gg posIn) {
        return stateIn.isCacheOpaqueCollisionShape();
    }

    public static Collection<clv> getProperties(cks blockState) {
        return blockState.s();
    }

    public static boolean isPropertyTrue(cks blockState, clj prop) {
        Boolean value = (Boolean)blockState.t().get((Object)prop);
        return Config.isTrue(value);
    }

    public static boolean isPropertyFalse(cks blockState, clj prop) {
        Boolean value = (Boolean)blockState.t().get((Object)prop);
        return Config.isFalse(value);
    }

    public static final class RenderSideCacheKey {
        private cks blockState1;
        private cks blockState2;
        private gl facing;
        private int hashCode;

        private RenderSideCacheKey(cks blockState1In, cks blockState2In, gl facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(cks blockState1In, cks blockState2In, gl facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

