/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.ppot.ct;

import cn.mcmod.ppot.PotmanRegistry;
import cn.mcmod.ppot.recipe.BasicPotRecipe;
import cn.mcmod.ppot.recipe.IPotRecipe;
import cn.mcmod.ppot.recipe.UniversalFluidPotRecipe;
import cn.mcmod_mmf.mmlib.recipe.UniversalFluid;
import cn.mcmod_mmf.mmlib.util.RecipesUtil;
import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.proj_pot.BasicPotRecipe")
@ZenRegister
public class CTBasicPotRecipe {
    @ZenMethod
    public static void addPotRecipe(String reg_name, IIngredient[] input_items, ILiquidStack[] input_fluids, IItemStack result) {
        CTBasicPotRecipe.addPotRecipe(reg_name, input_items, input_fluids, result, 200, 8000, 18000);
    }

    @ZenMethod
    public static void addPotRecipe(String reg_name, IIngredient[] input_items, String input_univerfluids, int fluid_amont, IItemStack result) {
        CTBasicPotRecipe.addPotRecipe(reg_name, input_items, input_univerfluids, fluid_amont, result, 200, 8000, 18000);
    }

    @ZenMethod
    public static void addPotRecipe(final String reg_name, IIngredient[] input_items, ILiquidStack[] input_fluids, IItemStack result, int cooking, int min, int max) {
        ArrayList listfluid = Lists.newArrayList();
        for (ILiquidStack ctfluid : input_fluids) {
            listfluid.add(CraftTweakerMC.getLiquidStack((ILiquidStack)ctfluid));
        }
        NonNullList items = NonNullList.func_191196_a();
        for (IIngredient ctingredient : input_items) {
            items.add((Object)CraftTweakerMC.getIngredient((IIngredient)ctingredient));
        }
        final BasicPotRecipe recipe = new BasicPotRecipe((NonNullList<Ingredient>)items, (List<FluidStack>)listfluid, CraftTweakerMC.getItemStack((IItemStack)result), cooking, min, max);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                PotmanRegistry.POT_RECIPE.register(recipe.setRegistryName(reg_name));
            }

            public String describe() {
                return "Adding basic pot recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void addPotRecipe(final String reg_name, IIngredient[] input_items, String input_univerfluids, int fluid_amont, IItemStack result, int cooking, int min, int max) {
        NonNullList items = NonNullList.func_191196_a();
        for (IIngredient ctingredient : input_items) {
            items.add((Object)CraftTweakerMC.getIngredient((IIngredient)ctingredient));
        }
        final UniversalFluidPotRecipe recipe = new UniversalFluidPotRecipe((NonNullList<Ingredient>)items, UniversalFluid.get((String)input_univerfluids), fluid_amont, CraftTweakerMC.getItemStack((IItemStack)result), cooking, min, max);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                PotmanRegistry.POT_RECIPE.register(recipe.setRegistryName(reg_name));
            }

            public String describe() {
                return "Adding an universal fluid pot recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack result) {
        ArrayList removeList = Lists.newArrayList();
        PotmanRegistry.POT_RECIPE.getValuesCollection().stream().filter(x -> RecipesUtil.getInstance().compareItems(x, (Object)CraftTweakerMC.getItemStack((IItemStack)result))).forEach(removeList::add);
        for (final IPotRecipe recipe : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)PotmanRegistry.POT_RECIPE;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing a pot recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final IPotRecipe recipe = (IPotRecipe)PotmanRegistry.POT_RECIPE.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)PotmanRegistry.POT_RECIPE;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing a pot recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

