/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.ppot.pot;

import cn.mcmod.ppot.CommonProxy;
import cn.mcmod.ppot.pot.IStove;
import cn.mcmod.ppot.pot.TileEntityFireStove;
import cn.mcmod_mmf.mmlib.block.BlockFacing;
import cn.mcmod_mmf.mmlib.util.WorldUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFireStove
extends BlockFacing
implements ITileEntityProvider,
IStove {
    protected static final AxisAlignedBB CAMPFIRE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    private final boolean isBurning;

    public BlockFireStove(boolean isBurning) {
        super(Material.field_151573_f, false);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.isBurning = isBurning;
        if (isBurning) {
            this.func_149715_a(0.85f);
        } else {
            this.func_149647_a(CreativeTabs.field_78031_c);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID && super.func_176196_c(worldIn, pos);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (hand == EnumHand.MAIN_HAND && tile instanceof TileEntityFireStove) {
            TileEntityFireStove tileEntityCampfire = (TileEntityFireStove)tile;
            if (WorldUtil.getInstance().isItemFuel(stack)) {
                tileEntityCampfire.setBurningTime(tileEntityCampfire.getBurningTime() + TileEntityFurnace.func_145952_a((ItemStack)stack));
                BlockFireStove.setState(true, worldIn, pos);
                return true;
            }
            return true;
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().onNeighborChange((IBlockAccess)worldIn, pos.func_177984_a(), pos);
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        IBlockState facing = worldIn.func_180495_p(pos);
        if (active) {
            worldIn.func_175656_a(pos, CommonProxy.STOVE_LIT.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)));
            worldIn.func_175656_a(pos, CommonProxy.STOVE_LIT.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)));
        } else {
            worldIn.func_175656_a(pos, CommonProxy.STOVE_IDLE.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)));
            worldIn.func_175656_a(pos, CommonProxy.STOVE_IDLE.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)));
        }
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d4 = rand.nextDouble() * 0.4 - 0.2;
        if (this.isBurning) {
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, (double)pos.func_177956_o() + 0.2, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, (double)pos.func_177956_o() + 0.2, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            if (rand.nextDouble() < 0.15) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFireStove();
    }

    @Override
    public boolean isHeating(World worldIn, IBlockState state) {
        return this.isBurning;
    }
}

