/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.ppot.pot.camppot;

import cn.mcmod.ppot.CommonProxy;
import cn.mcmod.ppot.PotmanMain;
import cn.mcmod.ppot.pot.camppot.TileEntityCampfirePot;
import cn.mcmod_mmf.mmlib.block.BlockFacing;
import cn.mcmod_mmf.mmlib.util.WorldUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockCampfirePot
extends BlockFacing
implements ITileEntityProvider {
    protected static final AxisAlignedBB CAMPFIRE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    public static final PropertyBool HASRESULT = PropertyBool.func_177716_a((String)"has_result");
    private final boolean isBurning;
    private static boolean keepInventory;

    public BlockCampfirePot(boolean isBurning) {
        super(Material.field_151575_d, false);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.isBurning = isBurning;
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf(false)));
        if (isBurning) {
            this.func_149715_a(0.85f);
        } else {
            this.func_149647_a(CreativeTabs.field_78031_c);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        int facing_meta = meta & 3;
        switch (facing_meta) {
            case 0: {
                facing = EnumFacing.SOUTH;
                break;
            }
            case 1: {
                facing = EnumFacing.WEST;
                break;
            }
            case 2: {
                facing = EnumFacing.NORTH;
                break;
            }
            case 3: {
                facing = EnumFacing.EAST;
                break;
            }
            default: {
                facing = EnumFacing.NORTH;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing).func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf((meta & 4) == 1));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        int result = (Boolean)state.func_177229_b((IProperty)HASRESULT) != false ? 1 : 0;
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + (result << 2);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, HASRESULT});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CAMPFIRE_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID && super.func_176196_c(worldIn, pos);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (hand == EnumHand.MAIN_HAND && tile instanceof TileEntityCampfirePot) {
            TileEntityCampfirePot tileEntityCampfire = (TileEntityCampfirePot)tile;
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            if (handler != null) {
                FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)((IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)));
                return true;
            }
            if (WorldUtil.getInstance().isItemFuel(stack)) {
                tileEntityCampfire.func_174885_b(0, tileEntityCampfire.func_174887_a_(0) + TileEntityFurnace.func_145952_a((ItemStack)stack));
                int heat = TileEntityFurnace.func_145952_a((ItemStack)stack) / 32;
                if (heat > 100) {
                    heat = 100;
                }
                tileEntityCampfire.func_174885_b(2, heat);
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    stack = stack.func_77973_b().getContainerItem(stack);
                } else {
                    stack.func_190918_g(1);
                }
                BlockCampfirePot.setState(true, tileEntityCampfire.isWorking(), worldIn, pos);
                return true;
            }
            playerIn.openGui((Object)PotmanMain.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().onNeighborChange((IBlockAccess)worldIn, pos.func_177984_a(), pos);
    }

    public static void setState(boolean active, boolean hasItem, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        IBlockState facing = worldIn.func_180495_p(pos);
        keepInventory = true;
        if (active) {
            worldIn.func_180501_a(pos, CommonProxy.CAMP_POT_LIT.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)).func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf(hasItem)), 3);
            worldIn.func_180501_a(pos, CommonProxy.CAMP_POT_LIT.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)).func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf(hasItem)), 3);
        } else {
            worldIn.func_180501_a(pos, CommonProxy.CAMP_POT_IDLE.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)).func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf(hasItem)), 3);
            worldIn.func_180501_a(pos, CommonProxy.CAMP_POT_IDLE.func_176223_P().func_177226_a((IProperty)field_185512_D, facing.func_177229_b((IProperty)field_185512_D)).func_177226_a((IProperty)HASRESULT, (Comparable)Boolean.valueOf(hasItem)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d4 = rand.nextDouble() * 0.4 - 0.2;
        if (this.isBurning) {
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, (double)pos.func_177956_o() + 0.2, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, (double)pos.func_177956_o() + 0.2, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            if (rand.nextDouble() < 0.15) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!keepInventory && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCampfirePot) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityCampfirePot)te));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCampfirePot();
    }
}

