/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.ppot.pot.camppot;

import cn.mcmod.ppot.pot.camppot.BlockCampfirePot;
import cn.mcmod.ppot.recipe.BasicPotRecipe;
import cn.mcmod.ppot.recipe.IPotRecipe;
import cn.mcmod_mmf.mmlib.util.RecipesUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCampfirePot
extends TileEntity
implements ITickable,
IInventory {
    public FluidTank tank = new FluidTank(2000){

        protected void onContentsChanged() {
            TileEntityCampfirePot.this.refresh();
        }
    };
    private FluidStack liquidForRendering = null;
    private int burnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int itemCookTime;
    private int maxCookTime;
    private int minitemCookTime;
    private int maxitemCookTime;
    private boolean working;
    protected NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);

    public FluidTank getTank() {
        return this.tank;
    }

    @SideOnly(value=Side.CLIENT)
    public FluidStack getFluidForRendering(float partialTicks) {
        FluidStack actual = this.tank.getFluid();
        if (actual != null && !actual.equals((Object)this.liquidForRendering)) {
            this.liquidForRendering = new FluidStack(actual, 0);
        }
        if (this.liquidForRendering == null) {
            return null;
        }
        int actualAmount = actual == null ? 0 : actual.amount;
        int delta = actualAmount - this.liquidForRendering.amount;
        if (Math.abs(delta) <= 40) {
            this.liquidForRendering.amount = actualAmount;
        } else {
            int i = (int)((double)((float)delta * partialTicks) * 0.1);
            if (i == 0) {
                i = delta > 0 ? 1 : -1;
            }
            this.liquidForRendering.amount += i;
        }
        if (this.liquidForRendering.amount == 0) {
            this.liquidForRendering = null;
        }
        return this.liquidForRendering;
    }

    public boolean isBurning() {
        return this.func_174887_a_(0) > 0;
    }

    protected void refresh() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 11);
        }
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag2 = this.isWorking();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        } else {
            this.currentItemBurnTime = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.getTank() != null) {
                ArrayList inventoryList = Lists.newArrayList();
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                    inventoryList.add(((ItemStack)this.inventory.get(i)).func_77946_l());
                }
                ItemStack itemstack = (ItemStack)this.inventory.get(9);
                FluidStack tank_fluid = this.getTank().getFluid();
                if (this.isRecipes(tank_fluid, inventoryList)) {
                    int i;
                    IPotRecipe current_recipe = BasicPotRecipe.get(tank_fluid, inventoryList);
                    ItemStack result = current_recipe.getResultItemStack(tank_fluid, inventoryList);
                    FluidStack fluidStack = current_recipe.getResultFluid(tank_fluid);
                    if (this.maxCookTime != current_recipe.getCookingTime()) {
                        this.maxCookTime = current_recipe.getCookingTime();
                    }
                    if (this.minitemCookTime != current_recipe.getMinCookingTime()) {
                        this.minitemCookTime = current_recipe.getMinCookingTime();
                    }
                    if (this.maxitemCookTime != current_recipe.getMaxCookingTime()) {
                        this.maxitemCookTime = current_recipe.getMaxCookingTime();
                    }
                    boolean bl = this.working = RecipesUtil.getInstance().canIncrease(result, itemstack) && this.isBurning();
                    if (this.working) {
                        ++this.cookTime;
                        this.itemCookTime += this.currentItemBurnTime;
                    } else {
                        this.cookTime = 0;
                        this.itemCookTime = 0;
                    }
                    if (this.itemCookTime > this.maxitemCookTime) {
                        this.cookTime = 0;
                        this.itemCookTime = 0;
                        for (i = 0; i < 9; ++i) {
                            if (!((ItemStack)this.inventory.get(i)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(i)).func_190926_b()) {
                                if (((ItemStack)this.inventory.get(i)).func_190916_E() == 1) {
                                    this.inventory.set(i, (Object)((ItemStack)this.inventory.get(i)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(i)).func_77946_l());
                                } else {
                                    this.func_70298_a(i, 1);
                                }
                                Block.func_180635_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)((ItemStack)this.inventory.get(i)).func_77973_b().getContainerItem(((ItemStack)this.inventory.get(i)).func_77946_l()));
                                continue;
                            }
                            this.func_70298_a(i, 1);
                        }
                        if (fluidStack != null && fluidStack.amount > 0) {
                            this.tank.drain(fluidStack, true);
                        }
                    }
                    if (this.cookTime >= current_recipe.getCookingTime()) {
                        this.cookTime = 0;
                        if (this.itemCookTime >= current_recipe.getMinCookingTime()) {
                            if (itemstack.func_190926_b()) {
                                this.inventory.set(9, (Object)result.func_77946_l());
                            } else if (itemstack.func_77969_a(result)) {
                                itemstack.func_190917_f(result.func_190916_E());
                            }
                            if (fluidStack != null && fluidStack.amount > 0) {
                                this.tank.drain(fluidStack, true);
                            }
                            for (i = 0; i < 9; ++i) {
                                if (!((ItemStack)this.inventory.get(i)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(i)).func_190926_b()) {
                                    if (((ItemStack)this.inventory.get(i)).func_190916_E() == 1) {
                                        this.inventory.set(i, (Object)((ItemStack)this.inventory.get(i)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(i)).func_77946_l());
                                    } else {
                                        this.func_70298_a(i, 1);
                                    }
                                    Block.func_180635_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)((ItemStack)this.inventory.get(i)).func_77973_b().getContainerItem(((ItemStack)this.inventory.get(i)).func_77946_l()));
                                    continue;
                                }
                                this.func_70298_a(i, 1);
                            }
                            flag1 = true;
                        }
                        this.itemCookTime = 0;
                    }
                } else {
                    this.working = false;
                    this.cookTime = 0;
                    this.itemCookTime = 0;
                    this.maxitemCookTime = 0;
                    this.minitemCookTime = 0;
                }
                if (flag != this.isBurning()) {
                    flag1 = true;
                    BlockCampfirePot.setState(this.isBurning(), this.isWorking(), this.field_145850_b, this.field_174879_c);
                } else if (flag2 != this.isWorking()) {
                    flag1 = true;
                    BlockCampfirePot.setState(this.isBurning(), this.isWorking(), this.field_145850_b, this.field_174879_c);
                }
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean isWorking() {
        return this.working;
    }

    public String func_70005_c_() {
        return "container.proj_pot.campfirepot";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 10;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        this.func_70296_d();
    }

    public void func_174886_c(EntityPlayer player) {
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < 9;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.cookTime;
            }
            case 2: {
                return this.currentItemBurnTime;
            }
            case 3: {
                return this.itemCookTime;
            }
            case 4: {
                return this.maxCookTime;
            }
            case 5: {
                return this.minitemCookTime;
            }
            case 6: {
                return this.maxitemCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.cookTime = value;
                break;
            }
            case 2: {
                this.currentItemBurnTime = value;
                break;
            }
            case 3: {
                this.itemCookTime = value;
                break;
            }
            case 4: {
                this.maxCookTime = value;
                break;
            }
            case 5: {
                this.minitemCookTime = value;
                break;
            }
            case 6: {
                this.maxitemCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 7;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        return this.burnTime * par1 / 200;
    }

    protected boolean isRecipes(FluidStack fluid, List<ItemStack> items) {
        ItemStack result;
        IPotRecipe recipe = BasicPotRecipe.get(fluid, items);
        return recipe != null && !(result = recipe.getResultItemStack(fluid, items)).func_190926_b();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound par1nbtTagCompound) {
        NBTTagCompound ret = super.func_189515_b(par1nbtTagCompound);
        this.writePacketNBT(ret);
        return ret;
    }

    @Nonnull
    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.readPacketNBT(par1nbtTagCompound);
    }

    public void writePacketNBT(NBTTagCompound cmp) {
        ItemStackHelper.func_191282_a((NBTTagCompound)cmp, this.inventory);
        cmp.func_74768_a("BurnTime", this.burnTime);
        cmp.func_74768_a("CookTime", this.cookTime);
        cmp.func_74768_a("ItemCookTime", this.itemCookTime);
        cmp.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        cmp.func_74757_a("isWorking", this.working);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        cmp.func_74782_a("Tank", (NBTBase)tankTag);
        if (this.tank.getFluid() != null) {
            this.liquidForRendering = this.tank.getFluid().copy();
        }
    }

    public void readPacketNBT(NBTTagCompound cmp) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)cmp, this.inventory);
        this.burnTime = cmp.func_74762_e("BurnTime");
        this.cookTime = cmp.func_74762_e("CookTime");
        this.itemCookTime = cmp.func_74762_e("ItemCookTime");
        this.working = cmp.func_74767_n("isWorking");
        this.currentItemBurnTime = cmp.func_74762_e("currentItemBurnTime");
        this.tank.readFromNBT(cmp.func_74775_l("Tank"));
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writePacketNBT(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, -999, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readPacketNBT(packet.func_148857_g());
    }

    public int getMinItemCookTime() {
        return this.minitemCookTime;
    }

    public int getMaxItemCookTime() {
        return this.maxitemCookTime;
    }

    public void setMaxItemCookTime(int maxitemCookTime) {
        this.maxitemCookTime = maxitemCookTime;
    }
}

