/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.ppot.recipe;

import cn.mcmod.ppot.PotmanRegistry;
import cn.mcmod.ppot.recipe.IPotRecipe;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BasicPotRecipe
extends IForgeRegistryEntry.Impl<IPotRecipe>
implements IPotRecipe {
    protected NonNullList<Ingredient> items = NonNullList.func_191196_a();
    protected List<FluidStack> fluidStacks;
    protected ItemStack resultItemStack;
    protected int cookingTime;
    protected int minCookingTime;
    protected int maxCookingTime;

    @Nullable
    public static IPotRecipe get(FluidStack fluid, List<ItemStack> inputs) {
        return PotmanRegistry.POT_RECIPE.getValuesCollection().stream().filter(x -> x.matches(fluid, inputs)).findFirst().orElse(null);
    }

    public BasicPotRecipe(NonNullList<Ingredient> item, List<FluidStack> fluid, ItemStack resultItem, int cookingTime, int minCookingTime, int maxCookingTime) {
        this.items = item;
        this.fluidStacks = fluid;
        this.resultItemStack = resultItem;
        this.cookingTime = cookingTime;
        this.minCookingTime = minCookingTime;
        this.maxCookingTime = maxCookingTime;
    }

    public BasicPotRecipe(Object[] item, List<FluidStack> fluid, ItemStack resultItem, int cookingTime, int minCookingTime, int maxCookingTime) {
        for (Object in : item) {
            Ingredient ing = CraftingHelper.getIngredient((Object)in);
            if (ing == null) {
                String ret = "Invalid Universal Pot recipe: ";
                for (Object tmp : item) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + resultItem;
                throw new RuntimeException(ret);
            }
            this.items.add((Object)ing);
        }
        this.fluidStacks = fluid;
        this.resultItemStack = resultItem;
        this.cookingTime = cookingTime;
        this.minCookingTime = minCookingTime;
        this.maxCookingTime = maxCookingTime;
    }

    @Override
    public boolean matches(FluidStack fluid, List<ItemStack> inputs) {
        if (inputs.size() != this.getItems().size()) {
            return false;
        }
        boolean flag = false;
        if (this.getFluid().isEmpty()) {
            flag = true;
        } else {
            for (FluidStack fluid_from : this.getFluid()) {
                if (!fluid_from.isFluidEqual(fluid)) continue;
                flag = true;
                break;
            }
        }
        return RecipeMatcher.findMatches(inputs, this.getItems()) != null && flag;
    }

    @Override
    public int getMaxCookingTime() {
        return this.maxCookingTime;
    }

    @Override
    public int getMinCookingTime() {
        return this.minCookingTime;
    }

    @Override
    public int getCookingTime() {
        return this.cookingTime;
    }

    @Override
    public NonNullList<Ingredient> getItems() {
        return this.items;
    }

    @Override
    public ItemStack getResultItemStack(FluidStack fluid, List<ItemStack> inputs) {
        return this.resultItemStack;
    }

    @Override
    public List<FluidStack> getFluid() {
        return this.fluidStacks;
    }

    @Override
    @Nullable
    public FluidStack getResultFluid(FluidStack fluid) {
        for (FluidStack k : this.getFluid()) {
            if (!k.isFluidEqual(fluid)) continue;
            return k;
        }
        return null;
    }

    @Override
    public ItemStack getResultItemStack() {
        return this.resultItemStack;
    }
}

