/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.client.config.AbstractConfigElement;
import vazkii.quark.base.client.config.ConfigObject;
import vazkii.quark.base.client.config.external.ExternalCategory;
import vazkii.quark.base.client.config.gui.CategoryScreen;
import vazkii.quark.base.client.config.gui.WidgetWrapper;
import vazkii.quark.base.client.config.gui.widget.IWidgetProvider;
import vazkii.quark.base.client.config.gui.widget.PencilButton;

public class ConfigCategory
extends AbstractConfigElement
implements IConfigCategory,
IWidgetProvider {
    public final List<IConfigElement> subElements = new LinkedList<IConfigElement>();
    private final String path;
    private final int depth;
    private boolean dirty = false;

    public ConfigCategory(String name, String comment, IConfigCategory parent) {
        super(name, comment, parent);
        if (parent == null || parent instanceof ExternalCategory) {
            this.path = name;
            this.depth = 0;
        } else {
            this.path = String.format("%s.%s", parent.getPath(), name);
            this.depth = 1 + parent.getDepth();
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public List<IConfigElement> getSubElements() {
        return this.subElements;
    }

    @Override
    public String getGuiDisplayName() {
        return WordUtils.capitalize((String)this.getName().replaceAll("_", " "));
    }

    @Override
    public void updateDirty() {
        this.dirty = false;
        for (IConfigElement sub : this.subElements) {
            if (!sub.isDirty()) continue;
            this.dirty = true;
            break;
        }
        if (this.parent != null) {
            this.parent.updateDirty();
        }
    }

    @Override
    public void clean() {
        this.subElements.forEach(IConfigElement::clean);
        this.dirty = false;
    }

    @Override
    public void save() {
        for (IConfigElement element : this.subElements) {
            if (!element.isDirty()) continue;
            element.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void refresh() {
        this.subElements.forEach(IConfigElement::refresh);
    }

    @Override
    public void reset(boolean hard) {
        this.subElements.forEach(e -> e.reset(hard));
    }

    @Override
    public IConfigCategory addCategory(String name, String comment) {
        return this.addCategory(new ConfigCategory(name, comment, this));
    }

    public IConfigCategory addCategory(IConfigCategory category) {
        this.subElements.add(category);
        return category;
    }

    @Override
    public <T> IConfigObject<T> addEntry(ForgeConfigSpec.ConfigValue<T> value, T default_, Supplier<T> getter, String comment, Predicate<Object> restriction) {
        IConfigObject<T> obj = ConfigObject.create(value, comment, default_, getter, restriction, this);
        this.addEntry(obj, default_);
        return obj;
    }

    public <T> void addEntry(IConfigObject<T> obj, T default_) {
        this.subElements.add(obj);
    }

    @Override
    public void close() {
        this.subElements.removeIf(e -> e instanceof ConfigCategory && ((ConfigCategory)e).subElements.isEmpty());
        Collections.sort(this.subElements);
    }

    @Override
    public void addWidgets(CategoryScreen parent, List<WidgetWrapper> widgets) {
        widgets.add(new WidgetWrapper((Widget)new PencilButton(230, 3, parent.categoryLink(this))));
    }

    @Override
    public void print(String pad, PrintStream stream) {
        stream.println();
        super.print(pad, stream);
        stream.printf("%s[%s]%n", pad, this.path);
        String newPad = String.format("\t%s", pad);
        this.subElements.forEach(e -> e.print(newPad, stream));
    }

    @Override
    public String getSubtitle() {
        int size = this.subElements.size();
        return size == 1 ? I18n.func_135052_a((String)"quark.gui.config.onechild", (Object[])new Object[0]) : I18n.func_135052_a((String)"quark.gui.config.nchildren", (Object[])new Object[]{this.subElements.size()});
    }

    @Override
    public int compareTo(IConfigElement o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof ConfigCategory)) {
            return 1;
        }
        return this.name.compareTo(((ConfigCategory)o).name);
    }
}

