/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeConfig;
import vazkii.quark.base.world.config.CostSensitiveEntitySpawnConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.content.mobs.client.render.FoxhoundRenderer;
import vazkii.quark.content.mobs.entity.FoxhoundEntity;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class FoxhoundModule
extends QuarkModule {
    public static EntityType<FoxhoundEntity> foxhoundType;
    @Config(description="The chance coal will tame a foxhound")
    public static double tameChance;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config
    public static EntitySpawnConfig lesserSpawnConfig;
    public static ITag<Block> foxhoundSpawnableTag;

    @Override
    public void construct() {
        foxhoundType = EntityType.Builder.func_220322_a(FoxhoundEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 0.8f).func_233606_a_(8).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new FoxhoundEntity((EntityType<? extends FoxhoundEntity>)foxhoundType, (World)world)).func_206830_a("foxhound");
        RegistryHelper.register(foxhoundType, (String)"foxhound");
        EntitySpawnHandler.registerSpawn(this, foxhoundType, EntityClassification.MONSTER, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FoxhoundEntity::spawnPredicate, spawnConfig);
        EntitySpawnHandler.track(this, foxhoundType, EntityClassification.MONSTER, lesserSpawnConfig, true);
        EntitySpawnHandler.addEgg(foxhoundType, 8981773, 15904587, spawnConfig);
    }

    @Override
    public void setup() {
        GlobalEntityTypeAttributes.put(foxhoundType, (AttributeModifierMap)WolfEntity.func_234233_eS_().func_233813_a_());
        foxhoundSpawnableTag = BlockTags.createOptional((ResourceLocation)new ResourceLocation("quark", "foxhound_spawnable"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(foxhoundType, FoxhoundRenderer::new);
    }

    @SubscribeEvent
    public void onAggro(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getEntityLiving().func_200600_R() == EntityType.field_200757_aw && event.getTarget().func_200600_R() == foxhoundType && ((FoxhoundEntity)event.getTarget()).func_70909_n()) {
            ((IronGolemEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    static {
        tameChance = 0.05;
        spawnConfig = new EntitySpawnConfig(30, 1, 2, BiomeConfig.fromBiomeReslocs(false, "minecraft:nether_wastes", "minecraft:basalt_deltas"));
        lesserSpawnConfig = new CostSensitiveEntitySpawnConfig(2, 1, 1, 0.7, 0.15, BiomeConfig.fromBiomeReslocs(false, "minecraft:soul_sand_valley"));
    }
}

