/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundEvent;
import vazkii.quark.content.tweaks.ai.WantLoveGoal;

public class NuzzleGoal
extends Goal {
    private final TameableEntity creature;
    private LivingEntity owner;
    private final double followSpeed;
    private final PathNavigator petPathfinder;
    private int timeUntilRebuildPath;
    private final float maxDist;
    private final float whineDist;
    private int whineCooldown;
    private float oldWaterCost;
    private final SoundEvent whine;

    public NuzzleGoal(TameableEntity creature, double followSpeed, float maxDist, float whineDist, SoundEvent whine) {
        this.creature = creature;
        this.followSpeed = followSpeed;
        this.petPathfinder = creature.func_70661_as();
        this.maxDist = maxDist;
        this.whineDist = whineDist;
        this.whine = whine;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        if (!(creature.func_70661_as() instanceof GroundPathNavigator) && !(creature.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        LivingEntity living = this.creature.func_70902_q();
        if (living == null || living.func_175149_v() || this.creature.func_233685_eM_()) {
            return false;
        }
        this.owner = living;
        return true;
    }

    public boolean func_75253_b() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        return !this.petPathfinder.func_75500_f() && this.creature.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.creature.func_233685_eM_();
    }

    public void func_75249_e() {
        this.timeUntilRebuildPath = 0;
        this.whineCooldown = 10;
        this.oldWaterCost = this.creature.func_184643_a(PathNodeType.WATER);
        this.creature.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.creature.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.creature.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.creature.func_70646_bf());
        if (!this.creature.func_233685_eM_() && --this.timeUntilRebuildPath <= 0) {
            this.timeUntilRebuildPath = 10;
            this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed);
        }
        if (this.creature.func_70068_e((Entity)this.owner) < (double)this.whineDist && --this.whineCooldown <= 0) {
            this.whineCooldown = 80 + this.creature.func_70681_au().nextInt(40);
            this.creature.func_184185_a(this.whine, 1.0f, 0.5f + (float)Math.random() * 0.5f);
        }
    }
}

