/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.GenerationStage;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.content.world.block.SpeleothemBlock;
import vazkii.quark.content.world.gen.SpeleothemGenerator;
import vazkii.quark.content.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.WORLD)
public class SpeleothemsModule
extends QuarkModule {
    @Config
    public static DimensionConfig dimensions = DimensionConfig.all();
    @Config
    public static int triesPerChunk = 60;
    @Config
    public static int speleothemsPerChunk = 12;
    @Config
    public static int triesPerChunkInNether = 4;
    @Config
    public static int speleothemsPerChunkInNether = 12;
    @Config
    public static int maxYlevel = 55;
    public static Map<Block, Block> speleothemMapping = new HashMap<Block, Block>();

    @Override
    public void modulesStarted() {
        this.make("stone", Blocks.field_150348_b, false);
        this.make("netherrack", Blocks.field_150424_aL, true);
        this.make("granite", Blocks.field_196650_c, false);
        this.make("diorite", Blocks.field_196654_e, false);
        this.make("andesite", Blocks.field_196656_g, false);
        this.make("marble", NewStoneTypesModule.marbleBlock, false).setCondition(() -> NewStoneTypesModule.enabledWithMarble);
        this.make("limestone", NewStoneTypesModule.limestoneBlock, false).setCondition(() -> NewStoneTypesModule.enabledWithLimestone);
        this.make("jasper", NewStoneTypesModule.jasperBlock, false).setCondition(() -> NewStoneTypesModule.enabledWithJasper);
        this.make("slate", NewStoneTypesModule.slateBlock, false).setCondition(() -> NewStoneTypesModule.enabledWithSlate);
        this.make("basalt", NewStoneTypesModule.basaltBlock, false).setCondition(() -> NewStoneTypesModule.enabledWithVoidstone);
    }

    private SpeleothemBlock make(String name, Block parent, boolean nether) {
        SpeleothemBlock block = new SpeleothemBlock(name, (QuarkModule)this, parent, nether);
        speleothemMapping.put(parent, (Block)block);
        return block;
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new SpeleothemGenerator(dimensions, Generator.NO_COND), GenerationStage.Decoration.UNDERGROUND_DECORATION, 2);
    }
}

