/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.rapid_leaf_decay.decayer;

import de.geheimagentnr1.rapid_leaf_decay.config.MainConfig;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayQueue;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayTask;
import java.util.ArrayList;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.WorldWorkerManager;

public class DecayWorker
implements WorldWorkerManager.IWorker {
    private int tickCount = 0;

    public boolean hasWork() {
        return true;
    }

    public boolean doWork() {
        ++this.tickCount;
        if (this.tickCount < MainConfig.getDecayDelay()) {
            return false;
        }
        this.tickCount = 0;
        for (DecayTask decayTask : DecayQueue.getElementsAndReset()) {
            BlockPos pos;
            ServerWorld world;
            BlockState state = decayTask.getState();
            Block block = state.func_177230_c();
            if (!BlockTags.field_206952_E.func_230235_a_((Object)block) || !(world = decayTask.getWorld()).func_195588_v(pos = decayTask.getPos())) continue;
            this.calculateDistances(state, pos, world);
            world.func_180495_p(pos).func_227034_b_(world, pos, world.func_201674_k());
        }
        return MainConfig.getDecayDelay() == 0 && DecayQueue.isNotEmpty();
    }

    private void calculateDistances(BlockState start_state, BlockPos start_pos, ServerWorld world) {
        ArrayList<Object> blockStates = new ArrayList<Object>();
        blockStates.add(start_state);
        ArrayList<Object> blockPoses = new ArrayList<Object>();
        blockPoses.add(start_pos);
        TreeSet<Object> poses = new TreeSet<Object>();
        poses.add(start_pos);
        while (!blockStates.isEmpty()) {
            BlockState current_blockState = (BlockState)blockStates.get(0);
            BlockPos current_blockPos = (BlockPos)blockPoses.get(0);
            ArrayList<BlockState> directionBlockStates = new ArrayList<BlockState>();
            ArrayList<BlockPos> directionBlockPoses = new ArrayList<BlockPos>();
            for (Direction direction : Direction.values()) {
                BlockState directionBlockState;
                BlockPos directionPos = current_blockPos.func_177972_a(direction);
                if (!world.func_195588_v(directionPos) || !BlockTags.field_206952_E.func_230235_a_((Object)(directionBlockState = world.func_180495_p(directionPos)).func_177230_c()) || ((Boolean)directionBlockState.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue() || poses.contains(directionPos)) continue;
                directionBlockStates.add(directionBlockState);
                directionBlockPoses.add(directionPos);
            }
            if (this.calculateDistance(current_blockState, current_blockPos, world)) {
                blockStates.addAll(directionBlockStates);
                blockPoses.addAll(directionBlockPoses);
                poses.addAll(directionBlockPoses);
            }
            blockStates.remove(0);
            blockPoses.remove(0);
            poses.remove(current_blockPos);
        }
    }

    private boolean calculateDistance(BlockState state, BlockPos pos, ServerWorld world) {
        Direction direction;
        BlockPos directionPos;
        int old_distance = (Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a);
        int distance = 7;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (distance = Math.min(distance, this.getDistance(world.func_180495_p(directionPos = pos.func_177972_a(direction = directionArray[i]))) + 1)) != 1; ++i) {
        }
        if (old_distance != distance) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(distance)));
            return true;
        }
        return false;
    }

    private int getDistance(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_230235_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof LeavesBlock ? (Integer)neighbor.func_177229_b((Property)LeavesBlock.field_208494_a) : 7;
    }
}

