/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.api.RatClientEvent;
import com.github.alexthe666.rats.client.model.ModelBiplane;
import com.github.alexthe666.rats.client.model.ModelPinkie;
import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.entity.LayerRatEyes;
import com.github.alexthe666.rats.client.render.entity.LayerRatHeldItem;
import com.github.alexthe666.rats.client.render.entity.LayerRatHelmet;
import com.github.alexthe666.rats.client.render.entity.LayerRatPlague;
import com.github.alexthe666.rats.client.render.entity.RenderRattlingGun;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRatBaronPlane;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRatBiplaneMount;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRattlingGun;
import com.github.alexthe666.rats.server.items.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class RenderRat
extends MobRenderer<EntityRat, SegmentedModel<EntityRat>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final ModelRat RAT_MODEL = new ModelRat(0.0f);
    private static final ModelPinkie PINKIE_MODEL = new ModelPinkie();
    private static final ResourceLocation PINKIE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/baby.png");
    private static final ResourceLocation ENDER_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_ender_upgrade.png");
    private static final ResourceLocation AQUATIC_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_aquatic_upgrade.png");
    private static final ResourceLocation DRAGON_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_dragon_upgrade.png");
    private static final ResourceLocation CARRAT_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_carrat_upgrade.png");
    private static final ResourceLocation ETHEREAL_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/ratlantis/ghost_pirat.png");
    private static final ResourceLocation UNDEAD_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_skeleton.png");
    private static final ResourceLocation BEE_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_bee_upgrade.png");
    private static final ResourceLocation JULIAN = new ResourceLocation("rats:textures/entity/rat/patreon/rat_julian.png");
    private static final ResourceLocation SHIZUKA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_shizuka.png");
    private static final ResourceLocation SHARVA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_sharva.png");
    private static final ResourceLocation DINO = new ResourceLocation("rats:textures/entity/rat/patreon/rat_dino.png");
    private static final ResourceLocation RATATLA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_ratatla.png");
    private static final ResourceLocation FRIAR = new ResourceLocation("rats:textures/entity/rat/patreon/rat_friar.png");
    private static final ResourceLocation RIDDLER = new ResourceLocation("rats:textures/entity/rat/patreon/rat_riddler.png");
    private static final ResourceLocation JOKER = new ResourceLocation("rats:textures/entity/rat/patreon/rat_joker.png");
    private static final ResourceLocation BUGRAAK = new ResourceLocation("rats:textures/entity/rat/patreon/rat_bugraak.png");
    private static final ResourceLocation LIL_CHEESE = new ResourceLocation("rats:textures/entity/rat/patreon/rat_lil_cheese.png");
    private static final ResourceLocation ZURA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_zura.png");
    private static final ResourceLocation SKRAT = new ResourceLocation("rats:textures/entity/rat/patreon/rat_skrat.png");

    public RenderRat() {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)RAT_MODEL, 0.15f);
        this.func_177094_a(new LayerRatPlague((IEntityRenderer<EntityRat, SegmentedModel<EntityRat>>)this));
        this.func_177094_a(new LayerRatEyes((IEntityRenderer<EntityRat, SegmentedModel<EntityRat>>)this));
        this.func_177094_a(new LayerRatHelmet((IEntityRenderer<EntityRat, SegmentedModel<EntityRat>>)this));
        this.func_177094_a(new LayerRatHeldItem((IEntityRenderer<EntityRat, SegmentedModel<EntityRat>>)this));
    }

    public <E extends Entity> void renderLeash(EntityRat entityLivingIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, E leashHolder) {
        matrixStackIn.func_227860_a_();
        double d0 = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)leashHolder.field_70177_z, (float)leashHolder.field_70126_B) * ((float)Math.PI / 180);
        double d1 = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)leashHolder.field_70125_A, (float)leashHolder.field_70127_C) * ((float)Math.PI / 180);
        double d2 = Math.cos(d0);
        double d3 = Math.sin(d0);
        double d4 = Math.sin(d1);
        if (leashHolder instanceof HangingEntity) {
            d2 = 0.0;
            d3 = 0.0;
            d4 = -1.0;
        }
        double d5 = Math.cos(d1);
        double d6 = MathHelper.func_219803_d((double)partialTicks, (double)leashHolder.field_70169_q, (double)leashHolder.func_226277_ct_()) - d2 * 0.7 - d3 * 0.5 * d5;
        double d7 = MathHelper.func_219803_d((double)partialTicks, (double)(leashHolder.field_70167_r + (double)leashHolder.func_70047_e() * 1.5), (double)(leashHolder.func_226278_cu_() + (double)leashHolder.func_70047_e() * 1.5)) - d4 * 0.25 - 0.125;
        double d8 = MathHelper.func_219803_d((double)partialTicks, (double)leashHolder.field_70166_s, (double)leashHolder.func_226281_cx_()) - d3 * 0.7 + d2 * 0.5 * d5;
        double d9 = (double)(MathHelper.func_219799_g((float)partialTicks, (float)entityLivingIn.field_70761_aq, (float)entityLivingIn.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        d2 = Math.cos(d9) * (double)entityLivingIn.func_213311_cf() * 0.4;
        d3 = Math.sin(d9) * (double)entityLivingIn.func_213311_cf() * 0.4;
        double d10 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70169_q, (double)entityLivingIn.func_226277_ct_()) + d2;
        double d11 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70167_r, (double)entityLivingIn.func_226278_cu_());
        double d12 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70166_s, (double)entityLivingIn.func_226281_cx_()) + d3;
        matrixStackIn.func_227861_a_(d2, -(1.6 - (double)entityLivingIn.func_213302_cg()) * 1.0, d3);
        float f = (float)(d6 - d10);
        float f1 = (float)(d7 - d11);
        float f2 = (float)(d8 - d12);
        float f3 = 0.025f;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(entityLivingIn.func_174824_e(partialTicks));
        BlockPos blockpos1 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int i = this.func_225624_a_((Entity)entityLivingIn, blockpos);
        int j = entityLivingIn.field_70170_p.func_226658_a_(LightType.BLOCK, blockpos1);
        int k = entityLivingIn.field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = entityLivingIn.field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        RenderRat.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.025f, (float)f5, (float)f6);
        RenderRat.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.0f, (float)f5, (float)f6);
        matrixStackIn.func_227865_b_();
    }

    protected boolean canRenderName(EntityRat entity) {
        return RatsMod.PROXY.shouldRenderNameplates() && super.func_177070_b((MobEntity)entity);
    }

    public void render(EntityRat entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_77045_g = entityIn.func_70631_g_() ? PINKIE_MODEL : RAT_MODEL;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public boolean shouldRender(EntityRat rat, ClippingHelper camera, double camX, double camY, double camZ) {
        if (rat.func_184218_aH() && rat.func_184187_bx() != null && rat.func_184187_bx().func_184188_bt().size() >= 1 && rat.func_184187_bx().func_184188_bt().get(0) == rat && rat.func_184187_bx() instanceof LivingEntity && ((LivingEntity)rat.func_184187_bx()).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == RatsItemRegistry.CHEF_TOQUE) {
            return false;
        }
        return super.func_225626_a_((MobEntity)rat, camera, camX, camY, camZ);
    }

    protected void preRenderCallback(EntityRat rat, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(0.6f, 0.6f, 0.6f);
        if (rat.func_184218_aH() && rat.func_184187_bx() != null && rat.func_184187_bx().func_184188_bt().size() >= 1) {
            if (rat.func_184187_bx() != null) {
                EntityRenderer playerRender;
                Entity riding;
                if (rat.func_184187_bx() instanceof PlayerEntity && (riding = rat.func_184187_bx()).func_184188_bt().get(0) != null && riding.func_184188_bt().get(0) == rat && (playerRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(riding)) instanceof LivingRenderer && ((LivingRenderer)playerRender).func_217764_d() instanceof BipedModel) {
                    ((BipedModel)((LivingRenderer)playerRender).func_217764_d()).field_78116_c.func_228307_a_(matrixStackIn);
                    matrixStackIn.func_227861_a_(0.0, (double)-0.7f, 0.25);
                }
                if (rat.func_184187_bx() instanceof EntityRattlingGun && (riding = rat.func_184187_bx()).func_184188_bt().get(0) != null && riding.func_184188_bt().get(0) == rat && (playerRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(riding)) instanceof LivingRenderer && ((LivingRenderer)playerRender).func_217764_d() instanceof BipedModel) {
                    RenderRattlingGun.GUN_MODEL.pivot.func_228307_a_(matrixStackIn);
                }
                if ((rat.func_184187_bx() instanceof EntityRatBaronPlane || rat.func_184187_bx() instanceof EntityRatBiplaneMount) && (riding = rat.func_184187_bx()).func_184188_bt().get(0) != null && riding.func_184188_bt().get(0) == rat && (playerRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(riding)) instanceof LivingRenderer && ((LivingRenderer)playerRender).func_217764_d() instanceof ModelBiplane) {
                    matrixStackIn.func_227861_a_(0.0, (double)-0.1f, (double)0.45f);
                    ((ModelBiplane)((LivingRenderer)playerRender).func_217764_d()).body1.func_228307_a_(matrixStackIn);
                }
            }
        } else {
            float f7 = rat.prevFlyingPitch + (rat.flyingPitch - rat.prevFlyingPitch) * partialTickTime;
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, rat.flyingPitch, true));
        }
    }

    public ResourceLocation getEntityTexture(EntityRat entity) {
        ResourceLocation resourcelocation;
        String s = entity.getRatTexture();
        if (entity.func_70631_g_()) {
            return PINKIE_TEXTURE;
        }
        if (entity.hasUpgrade(RatlantisItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            return ETHEREAL_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BEE)) {
            return BEE_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDEAD)) {
            return UNDEAD_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CARRAT)) {
            return CARRAT_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            return DRAGON_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER)) {
            return ENDER_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC)) {
            return AQUATIC_UPGRADE_TEXTURE;
        }
        if (entity.func_145818_k_()) {
            String str = entity.func_200201_e().getString().toLowerCase().replace(" ", "_");
            if (str.contains("julian")) {
                return JULIAN;
            }
            if (str.contains("shizuka")) {
                return SHIZUKA;
            }
            if (str.contains("sharva")) {
                return SHARVA;
            }
            if (str.contains("dino")) {
                return DINO;
            }
            if (str.contains("ratatla")) {
                return RATATLA;
            }
            if (str.contains("friar")) {
                return FRIAR;
            }
            if (str.contains("riddler")) {
                return RIDDLER;
            }
            if (str.contains("joker")) {
                return JOKER;
            }
            if (str.contains("bugraak")) {
                return BUGRAAK;
            }
            if (str.contains("lil_cheese")) {
                return LIL_CHEESE;
            }
            if (str.contains("zura")) {
                return ZURA;
            }
            if (str.contains("skrat")) {
                return SKRAT;
            }
        }
        if ((resourcelocation = LAYERED_LOCATION_CACHE.get(s)) == null) {
            resourcelocation = new ResourceLocation(s);
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        RatClientEvent.GetTexture textureEvent = new RatClientEvent.GetTexture(entity, this, resourcelocation);
        MinecraftForge.EVENT_BUS.post((Event)textureEvent);
        return textureEvent.getResult() == Event.Result.ALLOW ? textureEvent.getTexture() : resourcelocation;
    }

    protected float getDeathMaxRotation(EntityRat rat) {
        return rat.isDeadInTrap ? 0.0f : 90.0f;
    }
}

