/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.blocks.RatsFluidRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import com.github.alexthe666.rats.server.message.MessageAutoCurdlerFluid;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockAutoCurdler
extends ContainerBlock
implements IUsesTEISR {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)18.0, (double)16.0);

    public BlockAutoCurdler() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_226896_b_().func_208770_d().func_200948_a(2.0f, 0.0f));
        this.setRegistryName("rats", "auto_curdler");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("block.rats.auto_curdler.desc0").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.rats.auto_curdler.desc1").func_240699_a_(TextFormatting.GRAY));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityAutoCurdler) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityAutoCurdler)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!player.func_225608_bj_()) {
            boolean flag = false;
            ItemStack stack = player.func_184586_b(hand);
            if (TileEntityAutoCurdler.isMilk(stack) && worldIn.func_175625_s(pos) instanceof TileEntityAutoCurdler) {
                IFluidHandlerItem fluidHandler;
                TileEntityAutoCurdler te = (TileEntityAutoCurdler)worldIn.func_175625_s(pos);
                FluidStack fluidStack = BlockAutoCurdler.getFluidStack(stack);
                if (fluidStack != null && !worldIn.field_72995_K && (fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)) != null) {
                    FluidStack drain = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if ((drain.getAmount() > 0 || stack.func_77973_b() == Items.field_151117_aB) && te.tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.SIMULATE) != 0) {
                        int amount = te.tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                        if (!player.func_184812_l_()) {
                            fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                            ItemStack container = fluidHandler.getContainer();
                            if (stack != container) {
                                stack.func_190918_g(1);
                                player.func_191521_c(container);
                            } else if (stack.func_77973_b() == Items.field_151117_aB) {
                                stack.func_190918_g(1);
                                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar));
                            }
                        }
                        flag = true;
                    }
                    if (flag) {
                        RatsMod.sendMSGToAll(new MessageAutoCurdlerFluid(pos.func_218275_a(), te.tank.getFluid()));
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (!flag) {
                if (worldIn.field_72995_K) {
                    RatsMod.PROXY.setRefrencedTE(worldIn.func_175625_s(pos));
                } else {
                    INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, worldIn, pos);
                    if (inamedcontainerprovider != null) {
                        player.func_213829_a(inamedcontainerprovider);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (fluidStack.isEmpty() && stack.func_77973_b() == Items.field_151117_aB) {
            return new FluidStack(RatsFluidRegistry.MILK_FLUID, 1000);
        }
        return fluidStack;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityAutoCurdler();
    }
}

