/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.blocks.BlockRatCageDecorated;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageBreedingLantern;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageDecorated;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageWheel;
import com.github.alexthe666.rats.server.items.IRatCageDecoration;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRatCage
extends Block {
    public static final IntegerProperty NORTH = IntegerProperty.func_177719_a((String)"north", (int)0, (int)2);
    public static final IntegerProperty EAST = IntegerProperty.func_177719_a((String)"east", (int)0, (int)2);
    public static final IntegerProperty SOUTH = IntegerProperty.func_177719_a((String)"south", (int)0, (int)2);
    public static final IntegerProperty WEST = IntegerProperty.func_177719_a((String)"west", (int)0, (int)2);
    public static final IntegerProperty UP = IntegerProperty.func_177719_a((String)"up", (int)0, (int)2);
    public static final IntegerProperty DOWN = IntegerProperty.func_177719_a((String)"down", (int)0, (int)2);
    private static final VoxelShape BOTTOM_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape TOP_AABB = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);

    public BlockRatCage(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_208770_d().func_226896_b_().func_200948_a(2.0f, 0.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)EAST, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SOUTH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WEST, (Comparable)Integer.valueOf(0))).func_206870_a((Property)UP, (Comparable)Integer.valueOf(0))).func_206870_a((Property)DOWN, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("rats", name);
    }

    public BlockRatCage(String name, AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)EAST, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SOUTH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WEST, (Comparable)Integer.valueOf(0))).func_206870_a((Property)UP, (Comparable)Integer.valueOf(0))).func_206870_a((Property)DOWN, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("rats", name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("block.rats.rat_cage.desc0").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.rats.rat_cage.desc1").func_240699_a_(TextFormatting.GRAY));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, WEST, SOUTH, DOWN, UP});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstate, false, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstate1, false, Direction.WEST)))).func_206870_a((Property)SOUTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstate2, false, Direction.NORTH)))).func_206870_a((Property)WEST, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstate3, false, Direction.EAST)));
    }

    public int canFenceConnectTo(BlockState p_220111_1_, boolean p_220111_2_, Direction p_220111_3_) {
        if (p_220111_1_.func_177230_c() instanceof BlockRatTube) {
            return 2;
        }
        return p_220111_1_.func_177230_c() instanceof BlockRatCage ? 1 : 0;
    }

    public Item getItemDropped(BlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)RatsBlockRegistry.RAT_CAGE);
    }

    public ItemStack getItem(World worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)RatsBlockRegistry.RAT_CAGE);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (state.func_177230_c() instanceof BlockRatCage) {
            if ((Integer)state.func_177229_b((Property)UP) == 0) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)TOP_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if ((Integer)state.func_177229_b((Property)DOWN) == 0) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)BOTTOM_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if ((Integer)state.func_177229_b((Property)NORTH) == 0) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)NORTH_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if ((Integer)state.func_177229_b((Property)SOUTH) == 0) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)SOUTH_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if ((Integer)state.func_177229_b((Property)WEST) == 0) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)WEST_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if ((Integer)state.func_177229_b((Property)EAST) == 0) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)EAST_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return shape1;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof IRatCageDecoration && !this.hasTileEntity(state) && ((IRatCageDecoration)playerIn.func_184586_b(hand).func_77973_b()).canStay(worldIn, pos, this)) {
            Direction limitedFacing = playerIn.func_174811_aO().func_176734_d();
            if (!worldIn.field_72995_K) {
                // empty if block
            }
            if (playerIn.func_184586_b(hand).func_77973_b() == RatsItemRegistry.RAT_BREEDING_LANTERN) {
                BlockState pre = worldIn.func_180495_p(pos);
                BlockState decorated = (BlockState)RatsBlockRegistry.RAT_CAGE_BREEDING_LANTERN.func_176223_P().func_206870_a((Property)BlockRatCageDecorated.FACING, (Comparable)limitedFacing);
                decorated = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)decorated.func_206870_a((Property)NORTH, pre.func_177229_b((Property)NORTH))).func_206870_a((Property)EAST, pre.func_177229_b((Property)EAST))).func_206870_a((Property)SOUTH, pre.func_177229_b((Property)SOUTH))).func_206870_a((Property)WEST, pre.func_177229_b((Property)WEST))).func_206870_a((Property)UP, pre.func_177229_b((Property)UP))).func_206870_a((Property)DOWN, pre.func_177229_b((Property)DOWN));
                worldIn.func_180501_a(pos, decorated, 3);
                TileEntityRatCageBreedingLantern te = new TileEntityRatCageBreedingLantern();
                ItemStack added = new ItemStack((IItemProvider)playerIn.func_184586_b(hand).func_77973_b(), 1);
                te.setContainedItem(added);
                worldIn.func_175690_a(pos, (TileEntity)te);
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
            } else if (playerIn.func_184586_b(hand).func_77973_b() == RatsItemRegistry.RAT_WHEEL) {
                BlockState pre = worldIn.func_180495_p(pos);
                BlockState decorated = (BlockState)RatsBlockRegistry.RAT_CAGE_WHEEL.func_176223_P().func_206870_a((Property)BlockRatCageDecorated.FACING, (Comparable)limitedFacing);
                decorated = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)decorated.func_206870_a((Property)NORTH, pre.func_177229_b((Property)NORTH))).func_206870_a((Property)EAST, pre.func_177229_b((Property)EAST))).func_206870_a((Property)SOUTH, pre.func_177229_b((Property)SOUTH))).func_206870_a((Property)WEST, pre.func_177229_b((Property)WEST))).func_206870_a((Property)UP, pre.func_177229_b((Property)UP))).func_206870_a((Property)DOWN, pre.func_177229_b((Property)DOWN));
                worldIn.func_180501_a(pos, decorated, 3);
                TileEntityRatCageWheel te = new TileEntityRatCageWheel();
                ItemStack added = new ItemStack((IItemProvider)playerIn.func_184586_b(hand).func_77973_b(), 1);
                te.setContainedItem(added);
                worldIn.func_175690_a(pos, (TileEntity)te);
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
            } else {
                BlockState pre = worldIn.func_180495_p(pos);
                BlockState decorated = (BlockState)RatsBlockRegistry.RAT_CAGE_DECORATED.func_176223_P().func_206870_a((Property)BlockRatCageDecorated.FACING, (Comparable)limitedFacing);
                decorated = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)decorated.func_206870_a((Property)NORTH, pre.func_177229_b((Property)NORTH))).func_206870_a((Property)EAST, pre.func_177229_b((Property)EAST))).func_206870_a((Property)SOUTH, pre.func_177229_b((Property)SOUTH))).func_206870_a((Property)WEST, pre.func_177229_b((Property)WEST))).func_206870_a((Property)UP, pre.func_177229_b((Property)UP))).func_206870_a((Property)DOWN, pre.func_177229_b((Property)DOWN));
                worldIn.func_180501_a(pos, decorated, 3);
                TileEntityRatCageDecorated te = new TileEntityRatCageDecorated();
                ItemStack added = new ItemStack((IItemProvider)playerIn.func_184586_b(hand).func_77973_b(), 1);
                te.setContainedItem(added);
                worldIn.func_175690_a(pos, (TileEntity)te);
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (this.hasTileEntity(state)) {
            ItemStack stack = this.getContainedItem(worldIn, pos);
            boolean clearIt = true;
            if (stack != ItemStack.field_190927_a) {
                clearIt = playerIn.func_225608_bj_();
            }
            if (clearIt) {
                BlockState pre = worldIn.func_180495_p(pos);
                BlockState decorated = RatsBlockRegistry.RAT_CAGE.func_176223_P();
                decorated = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)decorated.func_206870_a((Property)NORTH, pre.func_177229_b((Property)NORTH))).func_206870_a((Property)EAST, pre.func_177229_b((Property)EAST))).func_206870_a((Property)SOUTH, pre.func_177229_b((Property)SOUTH))).func_206870_a((Property)WEST, pre.func_177229_b((Property)WEST))).func_206870_a((Property)UP, pre.func_177229_b((Property)UP))).func_206870_a((Property)DOWN, pre.func_177229_b((Property)DOWN));
                worldIn.func_180501_a(pos, decorated, 3);
                worldIn.func_175656_a(pos, decorated);
            }
        }
        if (playerIn.func_184586_b(hand).func_190926_b()) {
            boolean ridingRats = false;
            if (!playerIn.func_184188_bt().isEmpty()) {
                for (Entity entity : playerIn.func_184188_bt()) {
                    if (!(entity instanceof EntityRat)) continue;
                    ridingRats = true;
                    break;
                }
            }
            if (ridingRats) {
                int ratCount = 0;
                for (Entity entity : playerIn.func_184188_bt()) {
                    if (!(entity instanceof EntityRat) || ((EntityRat)entity).func_70631_g_()) continue;
                    EntityRat rat = (EntityRat)entity;
                    rat.func_184210_p();
                    rat.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    rat.func_70661_as().func_75499_g();
                    ++ratCount;
                }
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("entity.rats.rat.cage.deposit", new Object[]{ratCount}), true);
                return ActionResultType.SUCCESS;
            }
            int ratCount = 0;
            List list = worldIn.func_217357_a(EntityRat.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
            for (EntityRat rat : list) {
                if (!rat.func_70631_g_()) {
                    rat.func_70107_b(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_());
                }
                ++ratCount;
            }
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("entity.rats.rat.cage.withdrawal", new Object[]{ratCount}), true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public ItemStack getContainedItem(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRatCageDecorated) {
            return ((TileEntityRatCageDecorated)te).getContainedItem();
        }
        return ItemStack.field_190927_a;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        IntegerProperty connect = null;
        switch (facing) {
            case NORTH: {
                connect = NORTH;
                break;
            }
            case SOUTH: {
                connect = SOUTH;
                break;
            }
            case EAST: {
                connect = EAST;
                break;
            }
            case WEST: {
                connect = WEST;
                break;
            }
            case DOWN: {
                connect = DOWN;
                break;
            }
            default: {
                connect = UP;
            }
        }
        return (BlockState)stateIn.func_206870_a((Property)connect, (Comparable)Integer.valueOf(this.canFenceConnectTo(facingState, false, facing.func_176734_d())));
    }
}

