/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.compat.jei;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.compat.jei.archeologist.ArcheologistRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.cauldron.CauldronRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.chef.ChefRecipeCategory;
import com.github.alexthe666.rats.server.compat.jei.gemcutter.GemcutterRecipeCategory;
import com.github.alexthe666.rats.server.items.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class RatsJEIPlugin
implements IModPlugin {
    public static final ResourceLocation MOD = new ResourceLocation("rats:rats");
    public static final ResourceLocation CAULDRON_ID = new ResourceLocation("rats:cauldron");
    public static final ResourceLocation CHEF_RAT_ID = new ResourceLocation("rats:chef_rat");
    public static final ResourceLocation ARCHEOLOGIST_RAT_ID = new ResourceLocation("rats:archeologist_rat");
    public static final ResourceLocation GEMCUTTER_RAT_ID = new ResourceLocation("rats:gemcutter_rat");

    private void addDescription(IRecipeRegistration registry, ItemStack itemStack) {
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{itemStack.func_77977_a() + ".jei_desc"});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (RatConfig.cheesemaking) {
            registry.addRecipes(RatsRecipeRegistry.CAULDRON_RECIPES, CAULDRON_ID);
        }
        registry.addRecipes(RatsRecipeRegistry.RAT_CHEF_RECIPES, CHEF_RAT_ID);
        if (RatsMod.RATLANTIS_LOADED) {
            registry.addRecipes(RatsRecipeRegistry.RAT_ARCHEOLOGIST_RECIPES, ARCHEOLOGIST_RAT_ID);
        }
        registry.addRecipes(RatsRecipeRegistry.RAT_GEMCUTTER_RECIPES, GEMCUTTER_RAT_ID);
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.CHEESE));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.CHEESE_STICK));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.RAT_FLUTE));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_BASIC));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_CHEF));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_WHITELIST));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_BLACKLIST));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsBlockRegistry.RAT_TRAP));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsBlockRegistry.RAT_CAGE));
        this.addDescription(registry, new ItemStack((IItemProvider)RatsBlockRegistry.RAT_CRAFTING_TABLE));
        if (RatsMod.RATLANTIS_LOADED) {
            this.addDescription(registry, new ItemStack((IItemProvider)RatlantisItemRegistry.RAT_UPGRADE_ARCHEOLOGIST));
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (RatConfig.cheesemaking) {
            registry.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory()});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new ChefRecipeCategory()});
        if (RatsMod.RATLANTIS_LOADED) {
            registry.addRecipeCategories(new IRecipeCategory[]{new ArcheologistRecipeCategory()});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new GemcutterRecipeCategory()});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Items.field_222089_ms), new ResourceLocation[]{CAULDRON_ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_CHEF), new ResourceLocation[]{CHEF_RAT_ID});
        if (RatsMod.RATLANTIS_LOADED) {
            registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RatlantisItemRegistry.RAT_UPGRADE_ARCHEOLOGIST), new ResourceLocation[]{ARCHEOLOGIST_RAT_ID});
        }
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RatsItemRegistry.RAT_UPGRADE_GEMCUTTER), new ResourceLocation[]{GEMCUTTER_RAT_ID});
    }

    public ResourceLocation getPluginUid() {
        return MOD;
    }
}

