/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ISummonsRats;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.ai.PiperAIStrife;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityIllagerPiper
extends MonsterEntity
implements IRangedAttackMob,
ISummonsRats {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityIllagerPiper.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RAT_COUNT = EntityDataManager.func_187226_a(EntityIllagerPiper.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final PiperAIStrife aiArrowAttack = new PiperAIStrife(this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.2, false);
    private int ratCooldown = 0;
    private int fluteTicks = 0;

    public EntityIllagerPiper(EntityType type, World world) {
        super(type, world);
        this.setCombatTask();
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(RAT_COUNT, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityRat.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public boolean getCanSpawnHere(IWorld world, SpawnReason reason) {
        int spawnRoll = RatConfig.piperSpawnDecrease;
        if (RatUtils.canSpawnInDimension(world) && (spawnRoll == 0 || this.field_70146_Z.nextInt(spawnRoll) == 0)) {
            return super.func_213380_a(world, reason);
        }
        return false;
    }

    public void func_70106_y() {
        double dist = 20.0;
        for (EntityRat rat : this.field_70170_p.func_217357_a(EntityRat.class, new AxisAlignedBB(this.func_226277_ct_() - dist, this.func_226278_cu_() - dist, this.func_226281_cx_() - dist, this.func_226277_ct_() + dist, this.func_226278_cu_() + dist, this.func_226281_cx_() + dist))) {
            if (!rat.func_152114_e((LivingEntity)this)) continue;
            rat.func_70903_f(false);
            rat.func_184754_b(null);
            rat.fleePos = new BlockPos(rat.func_213303_ch());
            rat.func_70624_b(null);
            rat.func_70604_c(null);
        }
        super.func_70106_y();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("RatsSummoned", this.getRatsSummoned());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRatsSummoned(compound.func_74762_e("RatsSummoned"));
        this.setCombatTask();
    }

    @Override
    public boolean encirclesSummoner() {
        return false;
    }

    @Override
    public boolean readsorbRats() {
        return false;
    }

    @Override
    public int getRatsSummoned() {
        return (Integer)this.field_70180_af.func_187225_a(RAT_COUNT);
    }

    @Override
    public void setRatsSummoned(int count) {
        this.field_70180_af.func_187227_b(RAT_COUNT, (Object)count);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.summonRat();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        this.setCombatTask();
        return spawnDataIn;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EquipmentSlotType.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() == RatsItemRegistry.RAT_FLUTE) {
                int i = 100;
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)RatsItemRegistry.RAT_FLUTE));
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public void summonRat() {
        if (this.getRatsSummoned() < 6 && this.ratCooldown == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)82);
            EntityRat rat = new EntityRat(RatsEntityRegistry.RAT, this.field_70170_p);
            if (!this.field_70170_p.field_72995_K) {
                rat.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(new BlockPos(this.func_213303_ch())), SpawnReason.MOB_SUMMONED, null, null);
            }
            rat.func_82149_j((Entity)this);
            rat.setPlague(false);
            this.field_70170_p.func_217376_c((Entity)rat);
            rat.func_70903_f(false);
            rat.setTamedByMonster(true);
            rat.setMonsterOwnerUniqueId(this.func_110124_au());
            rat.setCommand(RatCommand.FOLLOW);
            if (this.func_70638_az() != null) {
                rat.func_70624_b(this.func_70638_az());
            }
            this.setRatsSummoned(this.getRatsSummoned() + 1);
            this.func_184185_a(RatsSoundRegistry.getFluteSound(), 0.25f, 1.0f);
            this.ratCooldown = 150;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.ratCooldown > 0) {
            --this.ratCooldown;
        }
        if (this.fluteTicks % 157 == 0) {
            this.func_184185_a(RatsSoundRegistry.PIPER_LOOP, 0.5f, 1.0f);
        }
        ++this.fluteTicks;
        if (this.fluteTicks % 10 == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
        }
        if (this.getRatsSummoned() < 3 && this.ratCooldown == 0 && this.field_70173_aa > 20) {
            this.summonRat();
        }
    }

    public static boolean canPiperSpawnInLight(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityIllagerPiper.func_223323_a((IServerWorld)((IServerWorld)worldIn), (BlockPos)pos, (Random)randomIn);
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        if (RatConfig.piperOverworldOnly && ((ServerWorld)worldIn).func_234923_W_() != World.field_234919_h_) {
            return false;
        }
        boolean b = EntityIllagerPiper.canPiperSpawnInLight(typeIn, (IWorld)worldIn, reason, pos, randomIn);
        return reason == SpawnReason.SPAWNER || b && worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn) && randomIn.nextFloat() < 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 82) {
            this.playEffect(0);
        } else if (id == 83) {
            this.playEffect(1);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect(int type) {
        BasicParticleType p = ParticleTypes.field_197597_H;
        if (type == 1) {
            double d0 = 0.0;
            this.field_70170_p.func_195594_a((IParticleData)p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, 0.0, 0.0);
        } else {
            double d0 = 0.65;
            for (int i = 0; i < 9; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, 0.0, 0.0);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e) && cause.func_76346_g() instanceof EntityRat) {
            if (new Random().nextBoolean()) {
                this.func_199702_a((IItemProvider)RatsItemRegistry.MUSIC_DISC_MICE_ON_VENUS, 1);
            } else {
                this.func_199702_a((IItemProvider)RatsItemRegistry.MUSIC_DISC_LIVING_MICE, 1);
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191270_ho;
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }
}

