/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityPurifyingLiquid;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.villager.RatsVillagerTrades;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.UseItemGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityPlagueDoctor
extends AbstractVillagerEntity
implements IRangedAttackMob {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_196606_bd))});
    private static final Predicate<Entity> PLAGUE_PREDICATE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof LivingEntity && ((LivingEntity)entity).func_70644_a(RatsMod.PLAGUE_POTION) || entity instanceof EntityRat && ((EntityRat)entity).hasPlague() || entity instanceof IPlagueLegion;
        }
    };
    private BlockPos wanderTarget;
    private int despawnDelay;
    private static final DataParameter<Boolean> WILL_DESPAWN = EntityDataManager.func_187226_a(EntityPlagueDoctor.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityPlagueDoctor(EntityType type, World worldIn) {
        super(type, worldIn);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new UseItemGoal((MobEntity)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185236_h), SoundEvents.field_219710_mV, p_213733_1_ -> !this.field_70170_p.func_72935_r() && !p_213733_1_.func_82150_aj()));
        this.field_70714_bg.func_75776_a(0, (Goal)new UseItemGoal((MobEntity)this, new ItemStack((IItemProvider)Items.field_151117_aB), SoundEvents.field_219722_na, p_213736_1_ -> this.field_70170_p.func_72935_r() && p_213736_1_.func_82150_aj()));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToGoal(this, 2.0, 0.35));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, PLAGUE_PREDICATE));
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WILL_DESPAWN, (Object)false);
    }

    public boolean willDespawn() {
        return (Boolean)this.field_70180_af.func_187225_a(WILL_DESPAWN);
    }

    public void setWillDespawn(boolean despawn) {
        this.field_70180_af.func_187227_b(WILL_DESPAWN, (Object)despawn);
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.willDespawn()) {
            this.handleDespawn();
        }
        if (this.func_70638_az() != null) {
            if (this.func_70638_az() instanceof EntityRat) {
                if (!((EntityRat)this.func_70638_az()).hasPlague()) {
                    this.func_70624_b(null);
                }
            } else if (this.func_70638_az() instanceof ZombieVillagerEntity) {
                if (((ZombieVillagerEntity)this.func_70638_az()).func_82230_o()) {
                    this.func_70624_b(null);
                }
            } else if (!this.func_70638_az().func_70644_a(RatsMod.PLAGUE_POTION) && !(this.func_70638_az() instanceof IPlagueLegion)) {
                this.func_70624_b(null);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
        compound.func_74757_a("WillDespawn", this.willDespawn());
        if (this.wanderTarget != null) {
            compound.func_218657_a("WanderTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.wanderTarget));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
        this.setWillDespawn(compound.func_74767_n("WillDespawn"));
        if (compound.func_74764_b("WanderTarget")) {
            this.wanderTarget = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("WanderTarget"));
        }
        this.func_70873_a(Math.max(0, this.func_70874_b()));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void setDespawnDelay(int delay) {
        this.despawnDelay = delay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.func_213716_dX() && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() != RatsMod.PLAGUE_POTION && super.func_70687_e(potioneffectIn);
    }

    protected boolean canDespawn() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_213716_dX() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected SoundEvent func_213351_c(ItemStack p_213351_1_) {
        Item item = p_213351_1_.func_77973_b();
        return item == Items.field_151117_aB ? SoundEvents.field_219711_mW : SoundEvents.field_219712_mX;
    }

    protected SoundEvent func_213721_r(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.field_219724_nc : SoundEvents.field_219714_mZ;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_219724_nc;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        double d0 = target.func_226278_cu_() + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.func_226277_ct_() + target.func_213322_ci().field_72450_a - this.func_226277_ct_();
        double d2 = d0 - this.func_226278_cu_();
        double d3 = target.func_226281_cx_() + target.func_213322_ci().field_72449_c - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
        EntityPurifyingLiquid entitypotion = new EntityPurifyingLiquid(this.field_70170_p, (LivingEntity)this, false);
        entitypotion.field_70125_A -= -20.0f;
        entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        this.field_70170_p.func_217376_c((Entity)entitypotion);
    }

    public void onStruckByLightning(LightningBoltEntity lightningBolt) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            EntityBlackDeath entitywitch = new EntityBlackDeath(RatsEntityRegistry.BLACK_DEATH, this.field_70170_p);
            entitywitch.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                entitywitch.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(this.func_213303_ch())), SpawnReason.MOB_SUMMONED, null, null);
            }
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_200203_b(this.func_200201_e());
            }
            this.field_70170_p.func_217376_c((Entity)entitywitch);
            this.func_70106_y();
        }
    }

    protected void func_213713_b(MerchantOffer p_213713_1_) {
        if (p_213713_1_.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    @Nullable
    private BlockPos func_213727_eh() {
        return this.wanderTarget;
    }

    public void setWanderTarget(@Nullable BlockPos blockpos1) {
        this.wanderTarget = blockpos1;
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] level1 = (VillagerTrades.ITrade[])RatsVillagerTrades.PLAGUE_DOCTOR_TRADES.get(1);
        VillagerTrades.ITrade[] level2 = (VillagerTrades.ITrade[])RatsVillagerTrades.PLAGUE_DOCTOR_TRADES.get(2);
        if (level1 != null && level2 != null) {
            MerchantOffer merchantoffer3;
            MerchantOffer merchantoffer2;
            int rolls;
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, level1, 5);
            int i = this.field_70146_Z.nextInt(level2.length);
            int j = this.field_70146_Z.nextInt(level2.length);
            int k = this.field_70146_Z.nextInt(level2.length);
            for (rolls = 0; j == i && rolls < 100; ++rolls) {
                j = this.field_70146_Z.nextInt(level2.length);
            }
            for (rolls = 0; (k == i || k == j) && rolls < 100; ++rolls) {
                k = this.field_70146_Z.nextInt(level2.length);
            }
            VillagerTrades.ITrade rareTrade1 = level2[i];
            VillagerTrades.ITrade rareTrade2 = level2[j];
            VillagerTrades.ITrade rareTrade3 = level2[k];
            MerchantOffer merchantoffer1 = rareTrade1.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer1 != null) {
                merchantoffers.add((Object)merchantoffer1);
            }
            if ((merchantoffer2 = rareTrade2.func_221182_a((Entity)this, this.field_70146_Z)) != null) {
                merchantoffers.add((Object)merchantoffer2);
            }
            if ((merchantoffer3 = rareTrade3.func_221182_a((Entity)this, this.field_70146_Z)) != null) {
                merchantoffers.add((Object)merchantoffer3);
            }
            if (!RatsMod.RATLANTIS_LOADED) {
                merchantoffers.add((Object)RatsVillagerTrades.COMBINER_TRADE.func_221182_a((Entity)this, this.field_70146_Z));
                merchantoffers.add((Object)RatsVillagerTrades.SEPERATOR_TRADE.func_221182_a((Entity)this, this.field_70146_Z));
                merchantoffers.add((Object)RatsVillagerTrades.UPGRADE_COMBINED_TRADE.func_221182_a((Entity)this, this.field_70146_Z));
            }
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            this.setWillDespawn(false);
            itemstack.func_111282_a_(player, (LivingEntity)this, hand);
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return super.func_230254_b_(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public class MoveToGoal
    extends Goal {
        final EntityPlagueDoctor plagueDoctor;
        final double range;
        final double speed;

        MoveToGoal(EntityPlagueDoctor p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.plagueDoctor = p_i50459_2_;
            this.range = p_i50459_3_;
            this.speed = p_i50459_5_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            this.plagueDoctor.setWanderTarget(null);
            EntityPlagueDoctor.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.plagueDoctor.func_213727_eh();
            return blockpos != null && this.func_220846_a(blockpos, this.range);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.plagueDoctor.func_213727_eh();
            if (blockpos != null && EntityPlagueDoctor.this.field_70699_by.func_75500_f()) {
                if (this.func_220846_a(blockpos, 10.0)) {
                    Vector3d vec3d = new Vector3d((double)blockpos.func_177958_n() - this.plagueDoctor.func_226277_ct_(), (double)blockpos.func_177956_o() - this.plagueDoctor.func_226278_cu_(), (double)blockpos.func_177952_p() - this.plagueDoctor.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.plagueDoctor.func_226277_ct_(), this.plagueDoctor.func_226278_cu_(), this.plagueDoctor.func_226281_cx_());
                    EntityPlagueDoctor.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    EntityPlagueDoctor.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean func_220846_a(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.plagueDoctor.func_213303_ch(), p_220846_2_);
        }
    }
}

