/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityDemonRat;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityPlagueBeast;
import com.github.alexthe666.rats.server.entity.EntityPlagueCloud;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityPlagueShot;
import com.github.alexthe666.rats.server.entity.EntityPurifyingLiquid;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatArrow;
import com.github.alexthe666.rats.server.entity.EntityRatBeastMount;
import com.github.alexthe666.rats.server.entity.EntityRatCaptureNet;
import com.github.alexthe666.rats.server.entity.EntityRatChickenMount;
import com.github.alexthe666.rats.server.entity.EntityRatDragonFire;
import com.github.alexthe666.rats.server.entity.EntityRatGolemMount;
import com.github.alexthe666.rats.server.entity.EntityRatKing;
import com.github.alexthe666.rats.server.entity.EntityRatShot;
import com.github.alexthe666.rats.server.entity.EntityRatSpawner;
import com.github.alexthe666.rats.server.entity.EntityRatStriderMount;
import com.github.alexthe666.rats.server.entity.EntitySmallArrow;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;

public class RatsEntityRegistry {
    public static final EntityType<EntityRat> RAT = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRat::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.49f, 0.49f), "rat");
    public static final EntityType<EntityRatSpawner> RAT_SPAWNER = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatSpawner::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 1.8f), "rat_spawner");
    public static final EntityType<EntityIllagerPiper> PIED_PIPER = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityIllagerPiper::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 1.8f), "pied_piper");
    public static final EntityType<EntityThrownBlock> THROWN_BLOCK = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityThrownBlock::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.95f, 0.95f).setCustomClientFactory(EntityThrownBlock::new), "thrown_block");
    public static final EntityType<EntityPlagueDoctor> PLAGUE_DOCTOR = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPlagueDoctor::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 1.8f), "plague_doctor");
    public static final EntityType<EntityPurifyingLiquid> PURIFYING_LIQUID = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPurifyingLiquid::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityPurifyingLiquid::new), "purifying_liquid");
    public static final EntityType<EntityBlackDeath> BLACK_DEATH = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityBlackDeath::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.8f, 1.8f), "black_death");
    public static final EntityType<EntityPlagueCloud> PLAGUE_CLOUD = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPlagueCloud::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 1.2f), "plague_cloud");
    public static final EntityType<EntityPlagueBeast> PLAGUE_BEAST = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPlagueBeast::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.85f, 1.2f), "plague_beast");
    public static final EntityType<EntityPlagueShot> PLAGUE_SHOT = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPlagueShot::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityPlagueShot::new), "plague_shot");
    public static final EntityType<EntityRatCaptureNet> RAT_CAPTURE_NET = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatCaptureNet::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityRatCaptureNet::new), "rat_capture_net");
    public static final EntityType<EntityRatDragonFire> RAT_DRAGON_FIRE = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatDragonFire::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityRatDragonFire::new), "rat_dragon_fire");
    public static final EntityType<EntityRatArrow> RAT_ARROW = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityRatArrow::new), "rat_arrow");
    public static final EntityType<EntityRatGolemMount> RAT_MOUNT_GOLEM = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatGolemMount::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.25f, 2.75f), "rat_mount_golem");
    public static final EntityType<EntityRatChickenMount> RAT_MOUNT_CHICKEN = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatChickenMount::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.65f, 0.75f), "rat_mount_chicken");
    public static final EntityType<EntityRatBeastMount> RAT_MOUNT_BEAST = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatBeastMount::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.85f, 1.2f), "rat_mount_beast");
    public static final EntityType<EntityRatKing> RAT_KING = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatKing::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.0f, 0.5f), "rat_king");
    public static final EntityType<EntityRatShot> RAT_SHOT = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatShot::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityRatShot::new), "rat_shot");
    public static final EntityType<EntityDemonRat> DEMON_RAT = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDemonRat::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 0.75f).func_220320_c().func_225435_d().setUpdateInterval(8), "demon_rat");
    public static final EntityType<EntityRatStriderMount> RAT_STRIDER_MOUNT = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityRatStriderMount::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.9f, 1.7f).setUpdateInterval(10), "rat_mount_strider");
    public static final EntityType<EntitySmallArrow> SMALL_ARROW = RatsEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntitySmallArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.39f, 0.39f).setCustomClientFactory(EntitySmallArrow::new), "small_arrow");

    private static final EntityType registerEntity(EntityType.Builder builder, String entityName) {
        ResourceLocation nameLoc = new ResourceLocation("rats", entityName);
        return (EntityType)builder.func_206830_a(entityName).setRegistryName(nameLoc);
    }

    public static void initializeAttributes() {
        GlobalEntityTypeAttributes.put(RAT, (AttributeModifierMap)EntityRat.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(RAT_SPAWNER, (AttributeModifierMap)EntityRat.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(PIED_PIPER, (AttributeModifierMap)EntityIllagerPiper.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(PLAGUE_DOCTOR, (AttributeModifierMap)EntityPlagueDoctor.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(BLACK_DEATH, (AttributeModifierMap)EntityBlackDeath.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(PLAGUE_CLOUD, (AttributeModifierMap)EntityPlagueCloud.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(PLAGUE_BEAST, (AttributeModifierMap)EntityPlagueBeast.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(RAT_MOUNT_CHICKEN, (AttributeModifierMap)EntityRatChickenMount.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(RAT_MOUNT_BEAST, (AttributeModifierMap)EntityRatBeastMount.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(RAT_KING, (AttributeModifierMap)EntityRatKing.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(DEMON_RAT, (AttributeModifierMap)EntityDemonRat.func_234290_eH_().func_233813_a_());
        GlobalEntityTypeAttributes.put(RAT_STRIDER_MOUNT, (AttributeModifierMap)EntityRatStriderMount.buildAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(RAT_MOUNT_GOLEM, (AttributeModifierMap)EntityRatGolemMount.buildAttributes().func_233813_a_());
    }

    static {
        EntitySpawnPlacementRegistry.func_209343_a(RAT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityRat::canEntityTypeSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(RAT_SPAWNER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityRatSpawner::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(PIED_PIPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityIllagerPiper::canSpawnOn);
        EntitySpawnPlacementRegistry.func_209343_a(DEMON_RAT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityDemonRat::canDemonRatSpawnOn);
    }
}

