/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RatAIDepositEnergy
extends Goal {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private BlockPos targetBlock = null;
    private int feedingTicks;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIDepositEnergy(EntityRat entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.getRFTransferRate() == 0 || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.TRANSPORT && this.entity.getCommand() != RatCommand.GATHER && this.entity.getCommand() != RatCommand.HUNT_ANIMALS && this.entity.getCommand() != RatCommand.HARVEST || this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.entity.getHeldRF() <= 0) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.getDepositPos();
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.getHeldRF() > 0;
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_213303_ch(), new Vector3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false, (Entity)this.entity);
        if (rayTrace instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    private Vector3d getMovePos() {
        BlockPos minusVec = this.targetBlock.func_177972_a(this.entity.depositFacing).func_177973_b((Vector3i)this.targetBlock);
        return new Vector3d((double)this.targetBlock.func_177958_n(), (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p()).func_72441_c((double)minusVec.func_177958_n() * 0.25, (double)minusVec.func_177956_o() * 0.25, (double)minusVec.func_177952_p() * 0.25);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity te = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            if ((this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER_ORE) || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER)) && !this.entity.func_70605_aq().func_75640_a() && this.entity.func_233570_aj_() && !this.entity.func_70661_as().func_75492_a(this.getMovePos().func_82615_a() + 0.5, this.getMovePos().func_82617_b(), this.getMovePos().func_82616_c() + 0.5, 1.25)) {
                RatUtils.doRatMinerLogic(this.entity, this.targetBlock, this);
            } else {
                this.entity.func_70661_as().func_75492_a(this.getMovePos().func_82615_a() + 0.5, this.getMovePos().func_82617_b() + 0.5, this.getMovePos().func_82616_c() + 0.5, 1.25);
                double distance = this.entity.getRatDistanceSq((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5);
                if (distance < 4.5 * this.entity.getRatDistanceModifier() && this.canSeeChest() && te != null) {
                    LazyOptional handler = te.getCapability(CapabilityEnergy.ENERGY, this.entity.depositFacing);
                    if (handler.orElse(null) == null) {
                        this.targetBlock = null;
                        this.func_75251_c();
                        return;
                    }
                    int howMuchWeHave = this.entity.getHeldRF();
                    int inputtedEnergy = 0;
                    try {
                        if (((IEnergyStorage)handler.orElse(null)).canReceive() && ((IEnergyStorage)handler.orElse(null)).receiveEnergy(howMuchWeHave, true) > 0) {
                            inputtedEnergy = ((IEnergyStorage)handler.orElse(null)).receiveEnergy(howMuchWeHave, false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (inputtedEnergy <= 0) {
                        this.targetBlock = null;
                        this.func_75251_c();
                    } else {
                        this.entity.setHeldRF(Math.max(0, this.entity.getHeldRF() - inputtedEnergy));
                        this.targetBlock = null;
                        this.func_75251_c();
                    }
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, BlockState state) {
        if (this.entity.field_70170_p instanceof ServerWorld) {
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List drops = state.func_177230_c().func_220076_a(state, loot);
            if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                for (ItemStack drop : drops) {
                    this.entity.func_70099_a(drop, 0.0f);
                }
                this.entity.field_70170_p.func_175655_b(pos, false);
                this.entity.fleePos = pos;
            }
        }
    }
}

