/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootTables;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RatAIHarvestFisherman
extends Goal {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private boolean hasReachedWater = false;
    private int fishingCooldown = 1000;
    private int throwCooldown = 0;
    private Random rand = new Random();
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public RatAIHarvestFisherman(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.entity.getCommand() == RatCommand.HARVEST && !this.entity.isInCage() && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b())) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
        this.hasReachedWater = false;
        this.fishingCooldown = 250 + this.rand.nextInt(750);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            if (this.hasReachedWater) {
                this.entity.func_70661_as().func_75499_g();
            }
            if (!this.hasReachedWater) {
                this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25);
            }
            if (this.isShore(this.targetBlock, this.entity.field_70170_p)) {
                double distance = this.entity.getRatDistanceCenterSq(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 4.5 * this.entity.getRatDistanceModifier()) {
                    if (this.throwCooldown == 0) {
                        this.entity.func_184185_a(SoundEvents.field_187612_G, 1.0f, 0.5f);
                        this.throwCooldown = 20;
                    }
                    this.hasReachedWater = true;
                } else {
                    this.hasReachedWater = false;
                }
            } else {
                this.targetBlock = null;
                this.func_75251_c();
            }
        }
        if (this.hasReachedWater) {
            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
            this.entity.crafting = true;
            if (this.fishingCooldown > 0) {
                --this.fishingCooldown;
            }
            if (this.fishingCooldown == 0) {
                this.spawnFishingLoot();
                this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)101);
                this.entity.func_184185_a(SoundEvents.field_187609_F, 1.0f, 1.0f);
            }
        } else {
            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
            this.entity.crafting = false;
        }
        if (this.throwCooldown > 0) {
            --this.throwCooldown;
        }
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.entity.getSearchRadius();
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            if (!this.isShore(pos, this.entity.field_70170_p)) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    private boolean isShore(BlockPos pos, World world) {
        for (Direction facing : HORIZONTALS) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() != Material.field_151586_h || !world.func_180495_p(pos).func_200015_d((IBlockReader)this.entity.field_70170_p, pos) || !world.func_175623_d(pos.func_177984_a())) continue;
            return true;
        }
        return false;
    }

    public void spawnFishingLoot() {
        this.fishingCooldown = 250 + this.rand.nextInt(750);
        double luck = 0.1;
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.entity.field_70170_p);
        lootcontext$builder.func_186469_a((float)luck);
        LootParameterSet.Builder lootparameterset$builder = new LootParameterSet.Builder();
        List result = this.entity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al).func_216113_a(lootcontext$builder.func_216022_a(lootparameterset$builder.func_216270_a()));
        for (ItemStack itemstack : result) {
            ItemEntity ItemEntity2 = new ItemEntity(this.entity.field_70170_p, this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), itemstack);
            if (this.entity.field_70170_p.field_72995_K) continue;
            this.entity.field_70170_p.func_217376_c((Entity)ItemEntity2);
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

