/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatQuarry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RatAIHarvestQuarry
extends Goal {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private static final ResourceLocation QUARRY_IGNORABLES = new ResourceLocation("rats", "quarry_ignorables");
    private BlockPos targetBlock = null;
    private int breakingTime;
    private int previousBreakProgress;
    private BlockState prevMiningState = null;
    private boolean buildStairs = false;
    private Direction stairDirection = Direction.NORTH;
    private ITag<Block> tag;

    public RatAIHarvestQuarry(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter(entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.tag = BlockTags.func_199896_a().func_199910_a(QUARRY_IGNORABLES);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_QUARRY) && this.entity.getDepositPos() != null) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos quarryPos = this.entity.getDepositPos();
        if (quarryPos != null && this.entity.field_70170_p.func_175625_s(quarryPos) instanceof TileEntityRatQuarry) {
            TileEntityRatQuarry quarry = (TileEntityRatQuarry)this.entity.field_70170_p.func_175625_s(quarryPos);
            int RADIUS = quarry.getRadius();
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)quarryPos.func_177982_a(-RADIUS, -1, -RADIUS), (BlockPos)quarryPos.func_177982_a(RADIUS, -quarryPos.func_177956_o() - 1, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                BlockState state;
                if ((this.entity.field_70170_p.func_175623_d(pos) || !this.doesListContainBlock(this.entity.field_70170_p, pos)) && !this.entity.field_70170_p.func_204610_c(pos).func_206889_d() || (state = this.entity.field_70170_p.func_180495_p(pos)).func_177230_c() == RatsBlockRegistry.RAT_QUARRY || state.func_177230_c() == RatsBlockRegistry.RAT_QUARRY_PLATFORM || this.tag.func_230235_a_((Object)state.func_177230_c()) || !(state.func_185887_b((IBlockReader)this.entity.field_70170_p, pos) > 0.0f)) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                this.targetBlock = (BlockPos)allBlocks.get(allBlocks.size() - 1);
                BlockPos stairs = quarry.getNextPosForStairs();
                if (stairs.func_177956_o() >= this.targetBlock.func_177956_o()) {
                    this.buildStairs = true;
                    this.stairDirection = quarry.stairDirection;
                    this.targetBlock = stairs;
                }
            }
        }
    }

    private boolean doesListContainBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        ItemStack getStack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
        return this.entity.canRatPickupItem(getStack);
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.buildStairs = false;
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            BlockPos rayPos = this.entity.rayTraceBlockPos(this.targetBlock);
            if (this.entity.field_70170_p.func_204610_c(this.targetBlock).func_206888_e() && this.entity.field_70170_p.func_175623_d(this.targetBlock)) {
                this.func_75251_c();
            }
            if (this.entity.func_180799_ab() && this.entity.field_70170_p.func_180495_p(this.entity.func_233580_cy_().func_177984_a()).func_196958_f()) {
                this.entity.field_70170_p.func_175656_a(this.entity.func_233580_cy_().func_177984_a(), Blocks.field_150355_j.func_176223_P());
                this.entity.func_70691_i(15.0f);
                this.entity.func_70683_ar().func_75660_a();
            }
            if (rayPos == null || !this.canMineBlock(rayPos)) {
                rayPos = this.targetBlock;
            }
            if (this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25)) {
                rayPos = this.targetBlock;
            } else {
                this.entity.func_70661_as().func_75492_a((double)rayPos.func_177958_n() + 0.5, (double)rayPos.func_177956_o(), (double)rayPos.func_177952_p() + 0.5, 1.25);
            }
            double distance = this.entity.getRatDistanceCenterSq((double)rayPos.func_177958_n() + 0.5, (double)rayPos.func_177956_o() + 0.5, (double)rayPos.func_177952_p() + 0.5);
            if (!this.entity.func_70605_aq().func_75640_a() && (this.entity.func_233570_aj_() || this.entity.func_70090_H() || this.entity.func_180799_ab() || this.entity.isRidingSpecialMount())) {
                BlockState block = this.entity.field_70170_p.func_180495_p(rayPos);
                SoundType soundType = block.func_177230_c().getSoundType(block, (IWorldReader)this.entity.field_70170_p, rayPos, null);
                if (this.buildStairs) {
                    if (distance < 6.0 * this.entity.getRatDistanceModifier()) {
                        this.entity.field_70170_p.func_175656_a(this.targetBlock, RatsBlockRegistry.RAT_QUARRY_PLATFORM.func_176223_P());
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.targetBlock = null;
                        this.prevMiningState = block;
                        this.entity.crafting = false;
                        this.func_75251_c();
                    }
                } else if (block.func_185904_a() != Material.field_151579_a && distance < 6.0 * this.entity.getRatDistanceModifier()) {
                    if (block.func_204520_s().func_206889_d()) {
                        BlockState replace = Blocks.field_150347_e.func_176223_P();
                        if (block.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
                            replace = Blocks.field_150343_Z.func_176223_P();
                        }
                        this.entity.field_70170_p.func_175656_a(rayPos, replace);
                        this.entity.func_70107_b(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() + 1.0, this.entity.func_226281_cx_());
                        this.entity.func_70691_i(2.0f);
                        this.func_75251_c();
                    }
                    this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                    this.entity.crafting = true;
                    if (block == this.prevMiningState) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                        this.entity.crafting = true;
                    } else {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.crafting = false;
                    }
                    if (distance < 1.5 * this.entity.getRatDistanceModifier()) {
                        this.entity.func_213293_j(0.0, 0.0, 0.0);
                        this.entity.func_70661_as().func_75499_g();
                    }
                    ++this.breakingTime;
                    int hardness = (int)(block.func_185887_b((IBlockReader)this.entity.field_70170_p, rayPos) * 10.0f);
                    int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                    if (this.breakingTime % 5 == 0) {
                        this.entity.func_184185_a(soundType.func_185846_f(), soundType.field_185860_m + 1.0f, soundType.field_185861_n);
                    }
                    if (i != this.previousBreakProgress) {
                        this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), rayPos, i);
                        this.previousBreakProgress = i;
                    }
                    if (this.breakingTime >= hardness) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.func_184185_a(soundType.func_185845_c(), soundType.field_185860_m, soundType.field_185861_n);
                        this.entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                        this.breakingTime = 0;
                        this.previousBreakProgress = -1;
                        this.destroyBlock(rayPos, block);
                        this.entity.fleePos = rayPos;
                        this.targetBlock = null;
                        this.entity.crafting = false;
                        this.func_75251_c();
                    }
                    this.prevMiningState = block;
                }
            }
        }
    }

    private boolean canMineBlock(BlockPos rayPos) {
        BlockState state = this.entity.field_70170_p.func_180495_p(rayPos);
        return !this.tag.func_230235_a_((Object)state.func_177230_c()) && state.func_177230_c() != RatsBlockRegistry.RAT_QUARRY && state.func_177230_c() != RatsBlockRegistry.RAT_QUARRY_PLATFORM && this.doesListContainBlock(this.entity.field_70170_p, rayPos);
    }

    private void destroyBlock(BlockPos pos, BlockState state) {
        if (this.entity.field_70170_p instanceof ServerWorld) {
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.entity.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List drops = state.func_177230_c().func_220076_a(state, loot);
            if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                for (ItemStack drop : drops) {
                    this.entity.func_70099_a(drop, 0.0f);
                }
                this.entity.field_70170_p.func_175655_b(pos, false);
                this.entity.fleePos = pos;
            }
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final EntityRat entity;

        public BlockSorter(EntityRat entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            FluidState state1 = this.entity.field_70170_p.func_204610_c(pos2);
            FluidState state2 = this.entity.field_70170_p.func_204610_c(pos1);
            double distance1 = pos2.func_177956_o();
            double distance2 = pos1.func_177956_o();
            if (state1.func_206889_d() && !state2.func_206889_d()) {
                return 1;
            }
            if (state2.func_206889_d() && !state1.func_206889_d()) {
                return -1;
            }
            int d = Double.compare(distance2, distance1);
            return d;
        }

        private double getDistance(BlockPos pos) {
            BlockPos depositPos = this.entity.getDepositPos();
            if (depositPos != null && this.entity.field_70170_p.func_175625_s(depositPos) instanceof TileEntityRatQuarry) {
                TileEntityRatQuarry quarry = (TileEntityRatQuarry)this.entity.field_70170_p.func_175625_s(depositPos);
                BlockPos perspective = depositPos.func_177982_a(-quarry.getRadius(), -1, -quarry.getRadius());
                double deltaX = (double)perspective.func_177958_n() - ((double)pos.func_177958_n() + 0.5);
                double deltaY = (double)perspective.func_177956_o() - ((double)pos.func_177956_o() + 0.5);
                double deltaZ = (double)perspective.func_177952_p() - ((double)pos.func_177952_p() + 0.5);
                return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            }
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

