/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.ai.RatAIMoveToBlock;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class RatAIRaidCrops
extends RatAIMoveToBlock {
    private final EntityRat entity;
    private boolean stop = false;

    public RatAIRaidCrops(EntityRat entity) {
        super((CreatureEntity)entity, 1.0, entity.getSearchRadius());
        this.entity = entity;
    }

    public static boolean isCrops(World world, BlockPos pos) {
        BlockState block = world.func_180495_p(pos.func_177984_a());
        return block.func_177230_c() instanceof CropsBlock;
    }

    @Override
    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.func_70909_n() || this.entity.isInCage() || !RatConfig.ratsBreakCrops) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (this.runDelay <= 0 && !ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
            return false;
        }
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    @Override
    public void func_75246_d() {
        double distance;
        BlockPos cropsPos;
        BlockState block;
        super.func_75246_d();
        if (this.getIsAboveDestination() && this.destinationBlock != null && (block = this.entity.field_70170_p.func_180495_p(cropsPos = this.destinationBlock.func_177984_a())).func_177230_c() instanceof CropsBlock && (distance = this.entity.getRatDistanceCenterSq(cropsPos.func_177958_n(), cropsPos.func_177956_o(), cropsPos.func_177952_p())) < 2.5 * this.entity.getRatDistanceModifier()) {
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216015_a(LootParameters.field_237457_g_, (Object)this.entity.func_213303_ch()).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List drops = block.func_177230_c().func_220076_a(block, loot);
            if (drops.isEmpty()) {
                this.stop = true;
            } else {
                int count = 0;
                for (ItemStack stack : drops) {
                    if (count == 0) {
                        ItemStack duplicate = stack.func_77946_l();
                        duplicate.func_190920_e(1);
                        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                            this.entity.func_70099_a(this.entity.func_184586_b(Hand.MAIN_HAND), 0.0f);
                        }
                        this.entity.func_184611_a(Hand.MAIN_HAND, duplicate);
                    }
                    ++count;
                }
                this.entity.field_70170_p.func_175655_b(cropsPos, false);
            }
            this.entity.fleePos = cropsPos;
            this.runDelay = 10;
        }
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        return RatAIRaidCrops.isCrops(worldIn, pos);
    }
}

