/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class RatAIWander
extends RandomWalkingGoal {
    private EntityRat rat;
    protected final float probability = 0.01f;

    public RatAIWander(EntityRat creatureIn, double speedIn) {
        super((CreatureEntity)creatureIn, speedIn, 200, false);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.rat = creatureIn;
        this.field_179481_f = 200;
    }

    @Nullable
    protected Vector3d func_190864_f() {
        if (this.rat.func_70090_H()) {
            Vector3d vec3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.rat, (int)15, (int)7);
            return vec3d == null ? this.generateRatPosition() : vec3d;
        }
        return this.rat.func_70681_au().nextFloat() >= this.probability && !this.rat.isInCage() ? RandomPositionGenerator.func_191377_b((CreatureEntity)this.rat, (int)10, (int)7) : this.generateRatPosition();
    }

    private Vector3d generateRatPosition() {
        boolean inCage;
        Vector3d vec3d = null;
        boolean bl = inCage = this.rat.isInCage() || this.rat.inTube();
        if (inCage) {
            if (this.rat.inTube()) {
                vec3d = RatUtils.generateRandomCagePos(this.rat, 30, 10, null, this.rat.waterBased);
                if (vec3d == null) {
                    vec3d = RatUtils.generateRandomCageOrTubePos(this.rat, 5, 5, null, false);
                }
            } else {
                vec3d = RatUtils.generateRandomTubePos(this.rat, 3, 2, null, this.rat.waterBased);
                if (vec3d == null) {
                    vec3d = RatUtils.findRandomCageOrTubeTarget(this.rat, 5, 2);
                }
            }
            if (vec3d != null) {
                BlockPos posToFind = RatUtils.findLowestRatCage(new BlockPos(vec3d), (CreatureEntity)this.rat);
                vec3d = new Vector3d((double)posToFind.func_177958_n(), (double)posToFind.func_177956_o(), (double)posToFind.func_177952_p());
            }
        }
        if (!inCage || vec3d == null) {
            Vector3d lvt_1_1_;
            vec3d = this.rat.waterBased ? RatUtils.generateRandomWaterPos((CreatureEntity)this.rat, this.rat.func_70909_n() ? 5 : 10, 7, null, true) : (this.field_75457_a.func_203005_aq() ? ((lvt_1_1_ = RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)15, (int)7)) == null ? super.func_190864_f() : lvt_1_1_) : (this.field_75457_a.func_70681_au().nextFloat() >= this.probability ? RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)10, (int)7) : super.func_190864_f()));
        }
        return vec3d;
    }

    public boolean func_75250_a() {
        this.field_179481_f = this.rat.isInCage() ? 15 : 200;
        return this.shouldRatAIExecute() && super.func_75250_a();
    }

    private boolean shouldRatAIExecute() {
        return this.rat.canMove() && !this.rat.hasFlightUpgrade() && !this.rat.isDancing() && !this.rat.isFleeing && this.rat.shouldWander();
    }
}

