/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ratlantis;

import com.github.alexthe666.rats.server.entity.ai.PiratBoatPathNavigate;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityCheeseCannonball;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityPirat;
import com.github.alexthe666.rats.server.entity.ratlantis.IPirat;
import com.github.alexthe666.rats.server.entity.ratlantis.IRatlantean;
import com.github.alexthe666.rats.server.entity.ratlantis.RatlantisEntityRegistry;
import com.github.alexthe666.rats.server.items.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityPiratBoat
extends MobEntity
implements IRatlantean,
IPirat {
    public ItemStack banner = EntityPiratBoat.generateBanner();
    private static final List<ItemStack> EMPTY_EQUIPMENT = Collections.emptyList();
    private static final DataParameter<Boolean> FIRING = EntityDataManager.func_187226_a(EntityPiratBoat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final float[] paddlePositions = new float[2];
    protected int navigatorType;
    private boolean prevFire;
    private int fireCooldown = 0;
    private double waterLevel;
    private BoatEntity.Status status;
    private BoatEntity.Status previousStatus;
    private double lastYd;

    public EntityPiratBoat(EntityType type, World worldIn) {
        super(type, worldIn);
        this.switchNavigator(0);
    }

    private static ItemStack generateBanner() {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196206_ev);
        CompoundNBT compoundnbt = itemstack.func_190925_c("BlockEntityTag");
        ListNBT listnbt = new BannerPattern.Builder().func_222477_a(RatsRecipeRegistry.RAT_AND_CROSSBONES_BANNER, DyeColor.WHITE).func_222476_a();
        compoundnbt.func_218657_a("Patterns", (INBT)listnbt);
        return itemstack;
    }

    protected void switchNavigator(int type) {
        if (type == 1) {
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.field_70765_h = new MovementController((MobEntity)this);
            this.navigatorType = 1;
        } else {
            this.field_70699_by = new PiratBoatPathNavigate(this, this.field_70170_p);
            this.field_70765_h = new MoveHelperController(this);
            this.navigatorType = 0;
        }
    }

    public boolean func_70039_c(CompoundNBT compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        super.func_70039_c(compound);
        return true;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public Entity func_184179_bs() {
        if (!this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityPirat)) continue;
                return entity;
            }
        }
        return null;
    }

    public double func_70033_W() {
        return 0.45;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 0.45, this.func_226281_cx_());
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRING, (Object)false);
    }

    public boolean isFiring() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRING);
    }

    public void setFiring(boolean male) {
        this.field_70180_af.func_187227_b(FIRING, (Object)male);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        Vector3d vec3d = this.func_213322_ci();
        this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        this.field_70757_a = 20;
        if (this.field_70725_aQ >= 80) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (PlayerEntity)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i);
                    this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                int j;
                for (j = 0; j < this.field_70146_Z.nextInt(3); ++j) {
                    this.func_70099_a(new ItemStack((IItemProvider)Items.field_151055_y), 0.0f);
                }
                for (j = 0; j < this.field_70146_Z.nextInt(3); ++j) {
                    this.func_70099_a(new ItemStack((IItemProvider)Blocks.field_196662_n), 0.0f);
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70099_a(this.banner.func_77946_l(), 0.0f);
                }
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.func_70099_a(new ItemStack((IItemProvider)RatlantisItemRegistry.CHEESE_CANNONBALL), 0.0f);
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    public void func_70071_h_() {
        boolean groundNavigate;
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        super.func_70071_h_();
        boolean bl = groundNavigate = !this.func_70090_H() && this.status != BoatEntity.Status.IN_WATER;
        if (!this.field_70170_p.field_72995_K) {
            if (groundNavigate && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (!groundNavigate && this.navigatorType != 0) {
                this.switchNavigator(0);
            }
        }
        if (this.func_184187_bx() != null && !this.func_184187_bx().func_184218_aH()) {
            this.func_184187_bx().func_184205_a((Entity)this, true);
        }
        if (this.prevFire != this.isFiring()) {
            this.fireCooldown = 4;
        }
        if (this.isFiring() && this.fireCooldown == 0) {
            this.setFiring(false);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        this.prevFire = this.isFiring();
        if (!this.func_184207_aI() && !this.field_70170_p.field_72995_K) {
            this.func_70097_a(DamageSource.field_76369_e, 1000.0f);
        }
        if (this.func_184179_bs() != null) {
            this.updateMotion();
            if (this.func_184179_bs() instanceof LivingEntity) {
                LivingEntity riding = (LivingEntity)this.func_184179_bs();
                this.field_70702_br = riding.field_70702_br;
                this.field_191988_bg = riding.field_191988_bg;
                this.func_213309_a(1.0f, new Vector3d((double)this.field_70702_br, 0.0, (double)this.field_191988_bg));
                this.field_70177_z = riding.field_70177_z;
                this.field_70759_as = riding.field_70759_as;
                this.field_70126_B = riding.field_70126_B;
            }
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof EntityPirat) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.1).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof BoatEntity) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_71061_d_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return EMPTY_EQUIPMENT;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public void shoot(EntityPirat pirat) {
        LivingEntity target = pirat.func_70638_az();
        if (target == null) {
            target = this.field_70170_p.func_217362_a((Entity)this, 30.0);
        }
        if (target != null) {
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70761_aq = this.field_70177_z = f % 360.0f;
            EntityCheeseCannonball cannonball = new EntityCheeseCannonball(RatlantisEntityRegistry.CHEESE_CANNONBALL, this.field_70170_p, (LivingEntity)pirat);
            float radius = 1.6f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            double extraY = 0.8 + this.func_226278_cu_();
            double d02 = target.func_226278_cu_() + (double)target.func_70047_e();
            double d1 = target.func_226277_ct_() - extraX;
            double d3 = target.func_226281_cx_() - extraZ;
            double d22 = d02 - extraY;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.65f;
            float velocity = this.func_70032_d((Entity)target) * 0.045f;
            cannonball.func_70107_b(extraX, extraY, extraZ);
            cannonball.func_70186_c(d1, d22 + (double)f2, d3, velocity, 0.4f);
            this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)cannonball);
            }
            this.setFiring(true);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            int l1 = i;
            while (true) {
                if (l1 >= j) {
                    if (!(f < 1.0f)) continue block0;
                    return (float)blockpos$mutable.func_177956_o() + f;
                }
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
                ++l1;
            }
        }
        return l + 1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    private boolean isOverWater() {
        return this.func_70090_H();
    }

    public BoatEntity.Status getBoatStatus() {
        BoatEntity.Status BoatEntity$status = this.getUnderwaterStatus();
        if (BoatEntity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72338_b;
            return BoatEntity$status;
        }
        if (this.checkInWater()) {
            return BoatEntity.Status.IN_WATER;
        }
        return BoatEntity.Status.ON_LAND;
    }

    @Nullable
    private BoatEntity.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return BoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? BoatEntity.Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float momentum = 0.45f;
        if (this.previousStatus == BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b;
            this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.501, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = BoatEntity.Status.IN_WATER;
        } else {
            if (this.status == BoatEntity.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.func_213302_cg() * 2.5;
                momentum = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                momentum = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_WATER) {
                d2 = 2.9f;
                momentum = 0.45f;
            } else if (this.status == BoatEntity.Status.IN_AIR) {
                momentum = 0.9f;
            } else if (this.status == BoatEntity.Status.ON_LAND) {
                // empty if block
            }
            Vector3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a * (double)momentum, vec3d.field_72448_b + d1, vec3d.field_72449_c * (double)momentum);
            if (d2 > 0.0) {
                Vector3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, (vec3d1.field_72448_b + d2 * 0.06153846016296973) * 0.75, vec3d1.field_72449_c);
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187881_gQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187881_gQ;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_213352_e(Vector3d vec) {
        super.func_213352_e(vec);
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityPiratBoat turtle;

        MoveHelperController(EntityPiratBoat turtleIn) {
            super((MobEntity)turtleIn);
            this.turtle = turtleIn;
        }

        public void func_75641_c() {
            double d2;
            double d1;
            double d0 = this.func_179917_d() - this.turtle.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = this.func_179919_e() - this.turtle.func_226278_cu_()) * d1 + (d2 = this.func_179918_f() - this.turtle.func_226281_cx_()) * d2;
            if (d3 < 2.500000277905201E-7) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.turtle.field_70761_aq = this.turtle.field_70177_z = this.func_75639_a(this.turtle.field_70177_z, f, 10.0f);
                this.turtle.field_70759_as = this.turtle.field_70177_z;
                float f1 = 1.0f;
                if (this.turtle.func_70090_H()) {
                    this.turtle.func_70659_e(f1 * 1.0f);
                    float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                    f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                    this.turtle.field_70125_A = this.func_75639_a(this.turtle.field_70125_A, f2, 5.0f);
                    float f3 = MathHelper.func_76134_b((float)(this.turtle.field_70125_A * ((float)Math.PI / 180)));
                    float f4 = MathHelper.func_76126_a((float)(this.turtle.field_70125_A * ((float)Math.PI / 180)));
                    this.turtle.field_191988_bg = f3 * f1;
                    this.turtle.field_70701_bs = -f4 * f1;
                } else {
                    this.turtle.func_70659_e(f1 * 1.0f);
                }
            }
        }
    }
}

