/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ratlantis;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.ratlantis.EntityRatlanteanFlame;
import com.github.alexthe666.rats.server.entity.ratlantis.IRatlantean;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityRatlanteanSpirit
extends MonsterEntity
implements IAnimatedEntity,
IRatlantean {
    public static final Animation ANIMATION_ATTACK = Animation.create((int)10);
    private int animationTick;
    private Animation currentAnimation;

    public EntityRatlanteanSpirit(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.field_70170_p.field_72995_K && this.field_70170_p.func_217362_a((Entity)this, 64.0) != null) {
            RatsMod.PROXY.addParticle("rat_ghost", this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.92f, 0.82, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_DIE;
    }

    public static boolean func_223315_a(EntityType<? extends MobEntity> p_223315_0_, IWorld p_223315_1_, SpawnReason p_223315_2_, BlockPos p_223315_3_, Random p_223315_4_) {
        BlockPos blockpos = p_223315_3_.func_177977_b();
        return p_223315_2_ == SpawnReason.SPAWNER || p_223315_1_.func_180495_p(blockpos).func_215688_a((IBlockReader)p_223315_1_, blockpos, p_223315_0_) && p_223315_4_.nextInt(5) == 0;
    }

    class AIFireballAttack
    extends Goal {
        private final EntityRatlanteanSpirit parentEntity;
        public int attackTimer;

        public AIFireballAttack(EntityRatlanteanSpirit ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (LivingEntity2.func_70068_e((Entity)this.parentEntity) >= 4096.0 || !this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                EntityRatlanteanSpirit.this.field_70765_h.func_75642_a(LivingEntity2.func_226277_ct_(), LivingEntity2.func_226278_cu_(), LivingEntity2.func_226281_cx_(), 0.5);
            }
            if (LivingEntity2.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    double d2 = LivingEntity2.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d3 = LivingEntity2.func_226278_cu_() + (double)LivingEntity2.func_213302_cg() - (this.parentEntity.func_226278_cu_() + (double)(this.parentEntity.func_213302_cg() / 2.0f));
                    double d4 = LivingEntity2.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    world.func_217378_a(null, 1016, new BlockPos(this.parentEntity.func_213303_ch()), 0);
                    EntityRatlanteanFlame entitylargefireball = new EntityRatlanteanFlame(world, (LivingEntity)this.parentEntity, d2, d3, d4);
                    entitylargefireball.func_70107_b(this.parentEntity.func_226277_ct_(), this.parentEntity.func_226278_cu_() + (double)(this.parentEntity.func_213302_cg() / 2.0f), this.parentEntity.func_226281_cx_());
                    world.func_217376_c((Entity)entitylargefireball);
                    this.attackTimer = -10;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !EntityRatlanteanSpirit.this.field_70765_h.func_75640_a() && EntityRatlanteanSpirit.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos(EntityRatlanteanSpirit.this.func_213303_ch());
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityRatlanteanSpirit.this.field_70146_Z.nextInt(15) - 7, EntityRatlanteanSpirit.this.field_70146_Z.nextInt(11) - 5, EntityRatlanteanSpirit.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityRatlanteanSpirit.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityRatlanteanSpirit.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityRatlanteanSpirit.this.func_70638_az() != null) break;
                EntityRatlanteanSpirit.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityRatlanteanSpirit vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vector3d vec3d = new Vector3d(this.func_179917_d() - EntityRatlanteanSpirit.this.func_226277_ct_(), this.func_179919_e() - EntityRatlanteanSpirit.this.func_226278_cu_(), this.func_179918_f() - EntityRatlanteanSpirit.this.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = EntityRatlanteanSpirit.this.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityRatlanteanSpirit.this.func_213317_d(EntityRatlanteanSpirit.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityRatlanteanSpirit.this.func_213317_d(EntityRatlanteanSpirit.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.1 / d0)));
                    if (EntityRatlanteanSpirit.this.func_70638_az() == null) {
                        Vector3d vec3d1 = EntityRatlanteanSpirit.this.func_213322_ci();
                        EntityRatlanteanSpirit.this.field_70761_aq = EntityRatlanteanSpirit.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityRatlanteanSpirit.this.func_70638_az().func_226277_ct_() - EntityRatlanteanSpirit.this.func_226277_ct_();
                        double d5 = EntityRatlanteanSpirit.this.func_70638_az().func_226281_cx_() - EntityRatlanteanSpirit.this.func_226281_cx_();
                        EntityRatlanteanSpirit.this.field_70761_aq = EntityRatlanteanSpirit.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

