/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ratlantis;

import com.github.alexthe666.rats.RatsMod;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;

public class PlaneBuffer {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    private boolean compareDouble(double a, double b) {
        double c = a - b;
        return Math.abs(c - 1.0) <= 3.0;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_70761_aq, entity.field_70760_ar) && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += MathHelper.func_76131_a((float)((entity.field_70760_ar - entity.field_70761_aq) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > 1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainPitchBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (!this.compareDouble(entity.field_70125_A, entity.field_70127_C) && MathHelper.func_76135_e((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += MathHelper.func_76131_a((float)((entity.field_70127_C - entity.field_70125_A) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > 1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = angleDecrement;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = angleDecrement;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (Math.abs(entity.field_70125_A) > maxAngle) {
            return;
        }
        if (!this.compareDouble(entity.field_70125_A, entity.field_70127_C) && MathHelper.func_76135_e((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += MathHelper.func_76131_a((float)((entity.field_70127_C - entity.field_70125_A) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > 1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_70761_aq, entity.field_70760_ar) && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += MathHelper.func_76131_a((float)((entity.field_70760_ar - entity.field_70761_aq) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > 1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainFlapBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * MathHelper.func_219799_g((float)this.prevYawVariation, (float)this.yawVariation, (float)RatsMod.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78796_g += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * MathHelper.func_219799_g((float)this.prevPitchVariation, (float)this.pitchVariation, (float)RatsMod.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78795_f += rotateAmount;
        }
    }

    public void applyChainFlapBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * MathHelper.func_219799_g((float)RatsMod.PROXY.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78808_h += rotateAmount;
        }
    }

    public void applyChainFlapBufferReverse(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * MathHelper.func_219799_g((float)RatsMod.PROXY.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78808_h -= rotateAmount * 0.5f;
        }
    }

    public void applyChainSwingBufferReverse(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * MathHelper.func_219799_g((float)RatsMod.PROXY.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78796_g -= rotateAmount;
        }
    }

    public void applyChainWaveBufferReverse(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * MathHelper.func_219799_g((float)RatsMod.PROXY.getPartialTicks(), (float)this.prevPitchVariation, (float)this.pitchVariation) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78795_f -= rotateAmount;
        }
    }
}

