/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.blocks.RatsFluidRegistry;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.inventory.ContainerAutoCurdler;
import com.github.alexthe666.rats.server.message.MessageAutoCurdlerFluid;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityAutoCurdler
extends LockableTileEntity
implements ITickableTileEntity,
ISidedInventory,
INamedContainerProvider {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    public int ticksExisted;
    public FluidTank tank = new FluidTank(5000);
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private NonNullList<ItemStack> curdlerStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public int cookTime;
    public int totalCookTime;
    private int prevFluid = 0;
    public final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 2: {
                    return TileEntityAutoCurdler.this.cookTime;
                }
                case 3: {
                    return TileEntityAutoCurdler.this.totalCookTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 2: {
                    TileEntityAutoCurdler.this.cookTime = value;
                    break;
                }
                case 3: {
                    TileEntityAutoCurdler.this.totalCookTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public TileEntityAutoCurdler() {
        super(RatsTileEntityRegistry.AUTO_CURDLER);
    }

    public static boolean isMilk(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151117_aB) {
            return true;
        }
        Optional fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack.orElse(null) != null && (((FluidStack)fluidStack.orElse(null)).getDisplayName().getString().toString().contains("milk") || ((FluidStack)fluidStack.orElse(null)).getTranslationKey().contains("Milk"));
    }

    public int func_70302_i_() {
        return this.curdlerStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.curdlerStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.curdlerStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.curdlerStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.curdlerStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.curdlerStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.curdlerStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.tank.readFromNBT(compound);
        this.curdlerStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.curdlerStacks);
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.tank.writeToNBT(compound);
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.curdlerStacks);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean isBurning() {
        return this.tank.getFluidAmount() >= 1000 && this.isMilkFluid(this.tank.getFluid());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.prevFluid != this.tank.getFluidAmount()) {
            RatsMod.sendMSGToAll(new MessageAutoCurdlerFluid(this.func_174877_v().func_218275_a(), this.tank.getFluid()));
            this.prevFluid = this.tank.getFluidAmount();
        }
        this.totalCookTime = RatConfig.milkCauldronTime;
        ++this.ticksExisted;
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            if (this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == this.totalCookTime) {
                    this.cookTime = 0;
                    this.totalCookTime = RatConfig.milkCauldronTime;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
        } else if (!this.isBurning() && this.cookTime > 0) {
            this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
        }
        if (((ItemStack)this.curdlerStacks.get(0)).func_77973_b() == Items.field_151117_aB) {
            FluidBucketWrapper milkWrapper = new FluidBucketWrapper(new ItemStack((IItemProvider)Items.field_151117_aB));
            FluidStack milkFluid = new FluidStack(milkWrapper.getFluid(), 1000);
            if (milkFluid.isEmpty()) {
                milkFluid = new FluidStack(RatsFluidRegistry.MILK_FLUID, 1000);
            }
            if (this.tank.fill(milkFluid.copy(), IFluidHandler.FluidAction.SIMULATE) != 0) {
                this.tank.fill(milkFluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                this.curdlerStacks.set(0, (Object)new ItemStack((IItemProvider)Items.field_151133_ar));
            }
        } else if (TileEntityAutoCurdler.isMilk((ItemStack)this.curdlerStacks.get(0))) {
            Optional fluidStackOptional = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.curdlerStacks.get(0)));
            fluidStackOptional.ifPresent(fluidStack -> {
                LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.curdlerStacks.get(0)));
                fluidHandlerOptional.ifPresent(fluidHandler -> {
                    if (fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount() > 0 && this.tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.SIMULATE) != 0) {
                        int amount = this.tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                        fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack container = fluidHandler.getContainer();
                        if (this.curdlerStacks.get(0) != container) {
                            this.curdlerStacks.set(0, (Object)container);
                        }
                    }
                });
            });
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack toAdd = new ItemStack((IItemProvider)RatsBlockRegistry.BLOCK_OF_CHEESE);
            if (this.func_70301_a(1).func_77969_a(toAdd) && this.func_70301_a(1).func_190916_E() < 64) {
                this.func_70301_a(1).func_190917_f(1);
            } else if (this.func_70301_a(1).func_190926_b()) {
                this.func_70299_a(1, toAdd.func_77946_l());
            }
            this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean canSmelt() {
        if (this.tank.getFluidAmount() < 1000) {
            return false;
        }
        ItemStack itemstack = new ItemStack((IItemProvider)RatsBlockRegistry.BLOCK_OF_CHEESE);
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.curdlerStacks.get(1);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void func_174889_b(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K) {
            RatsMod.sendMSGToAll(new MessageAutoCurdlerFluid(this.func_174877_v().func_218275_a(), this.tank.getFluid()));
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K) {
            RatsMod.sendMSGToAll(new MessageAutoCurdlerFluid(this.func_174877_v().func_218275_a(), this.tank.getFluid()));
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 1) {
            return false;
        }
        return TileEntityAutoCurdler.isMilk(stack);
    }

    private boolean isMilkFluid(FluidStack fluid) {
        return fluid.getTranslationKey().contains("milk") || fluid.getTranslationKey().contains("Milk");
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.tank.getFluidAmount();
            }
            case 1: {
                return this.cookTime;
            }
            case 2: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                if (this.tank.getFluid() == null) break;
                this.tank.getFluid().setAmount(value);
                break;
            }
            case 1: {
                this.cookTime = value;
                break;
            }
            case 2: {
                this.totalCookTime = value;
            }
        }
    }

    public int getFieldCount() {
        return 3;
    }

    public void func_174888_l() {
        this.curdlerStacks.clear();
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        return SLOTS_TOP;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return true;
        }
        return false;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.auto_curdler");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[0].cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerAutoCurdler(id, (IInventory)this, playerInventory, this.furnaceData);
    }
}

