/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageDecorated;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityRatCageBreedingLantern
extends TileEntityRatCageDecorated
implements ITickableTileEntity {
    public int breedingCooldown = 0;
    private Random random = new Random();

    public TileEntityRatCageBreedingLantern() {
        super(RatsTileEntityRegistry.RAT_CAGE_BREEDING_LANTERN);
    }

    @Override
    public ItemStack getContainedItem() {
        return new ItemStack((IItemProvider)RatsItemRegistry.RAT_BREEDING_LANTERN);
    }

    @Override
    public void setContainedItem(ItemStack stack) {
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("BreedingCooldown", this.breedingCooldown);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.breedingCooldown = compound.func_74762_e("BreedingCooldown");
    }

    public void func_73660_a() {
        float f = (24000.0f - (float)this.breedingCooldown) / 24000.0f;
        float f1 = f * 0.6f + 0.4f;
        float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
        float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
        float i = (float)this.func_174877_v().func_177958_n() + 0.5f;
        float j = (float)this.func_174877_v().func_177956_o() + 0.5f;
        float k = (float)this.func_174877_v().func_177952_p() + 0.5f;
        if (this.breedingCooldown <= 0) {
            double d0 = 1.5;
            List rats = this.field_145850_b.func_217357_a(EntityRat.class, new AxisAlignedBB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0));
            if (rats.size() < RatConfig.ratCageCramming && rats.size() > 0) {
                ArrayList<EntityRat> males = new ArrayList<EntityRat>();
                ArrayList<EntityRat> females = new ArrayList<EntityRat>();
                for (EntityRat rat : rats) {
                    if (rat.func_70631_g_() || !rat.isInCage() || rat.breedCooldown != 0) continue;
                    if (rat.isMale()) {
                        males.add(rat);
                        continue;
                    }
                    females.add(rat);
                }
                if (males.size() > 0 && females.size() > 0) {
                    EntityRat male = (EntityRat)males.get(0);
                    EntityRat female = (EntityRat)females.get(0);
                    if (males.size() > 1) {
                        male = (EntityRat)males.get(this.random.nextInt(males.size() - 1));
                    }
                    if (females.size() > 1) {
                        female = (EntityRat)females.get(this.random.nextInt(females.size() - 1));
                    }
                    male.field_70170_p.func_72960_a((Entity)male, (byte)83);
                    female.field_70170_p.func_72960_a((Entity)female, (byte)83);
                    female.createBabiesFrom(female, male);
                    this.breedingCooldown = 24000;
                    male.breedCooldown = 24000;
                    female.breedCooldown = 24000;
                }
            }
        } else {
            --this.breedingCooldown;
        }
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)i + this.random.nextDouble() - 0.5, (double)j + this.random.nextDouble() - 0.5, (double)k + this.random.nextDouble() - 0.5, (double)f1, (double)f2, (double)f3);
        }
    }
}

