/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.BlockRatCageWheel;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.tile.RatsEnergyStorage;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageDecorated;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityRatCageWheel
extends TileEntityRatCageDecorated
implements ITickableTileEntity {
    public int useTicks = 0;
    public float wheelRot;
    public float prevWheelRot;
    private Random random = new Random();
    private EntityRat wheeler;
    private float goalOfWheel = 0.0f;
    private int dismountCooldown = 0;
    public LazyOptional<RatsEnergyStorage> energyStorage = RatsEnergyStorage.create(this, 1000, 10, 10, 0);

    public TileEntityRatCageWheel() {
        super(RatsTileEntityRegistry.RAT_CAGE_WHEEL);
    }

    @Override
    public ItemStack getContainedItem() {
        return new ItemStack((IItemProvider)RatsItemRegistry.RAT_WHEEL);
    }

    @Override
    public void setContainedItem(ItemStack stack) {
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("UseTicks", this.useTicks);
        if (this.energyStorage.isPresent()) {
            compound.func_74768_a("StoredEnergy", ((RatsEnergyStorage)this.energyStorage.orElse(null)).energy);
        }
        compound.func_74768_a("DismountCooldown", this.dismountCooldown);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.useTicks = compound.func_74762_e("UseTicks");
        this.dismountCooldown = compound.func_74762_e("DismountCooldown");
        if (this.energyStorage.isPresent()) {
            ((RatsEnergyStorage)this.energyStorage.orElse(null)).energy = compound.func_74762_e("StoredEnergy");
        }
    }

    public void func_73660_a() {
        this.prevWheelRot = this.wheelRot;
        float wheelAdd = 20.0f;
        if (this.dismountCooldown > 0) {
            --this.dismountCooldown;
        }
        if (this.wheeler == null && this.dismountCooldown <= 0) {
            for (EntityRat rat : this.field_145850_b.func_217357_a(EntityRat.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 1.0))) {
                if (!rat.func_70909_n()) continue;
                this.wheeler = rat;
            }
        }
        if (this.wheeler != null) {
            double dist = this.wheeler.func_70092_e((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.5f, (float)this.func_174877_v().func_177952_p() + 0.5f);
            BlockState ratWheelState = this.field_145850_b.func_180495_p(this.wheeler.func_233580_cy_());
            Direction facing = Direction.NORTH;
            if (this.func_195044_w().func_177230_c() == RatsBlockRegistry.RAT_CAGE_WHEEL) {
                facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockRatCageWheel.FACING);
            }
            this.wheeler.field_70761_aq = this.wheeler.field_70177_z = facing.func_185119_l();
            if (this.useTicks > 20 && (dist > 3.0 || ratWheelState != this.func_195044_w())) {
                this.wheeler.setInWheel(false);
                this.wheeler = null;
            } else if (this.wheeler != null) {
                this.wheeler.func_70107_b((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.15f, (float)this.func_174877_v().func_177952_p() + 0.5f);
                this.wheeler.setInWheel(true);
                ++this.useTicks;
                RatsEnergyStorage storage = (RatsEnergyStorage)this.energyStorage.orElse(null);
                int nrg = 10;
                if (this.wheeler.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SPEED)) {
                    wheelAdd = 40.0f;
                    nrg = 20;
                }
                if (storage != null && storage.receiveEnergy(nrg, true) != 0) {
                    storage.receiveEnergy(nrg, false);
                }
                this.wheelRot += wheelAdd;
                BlockRatCage cageBlock = (BlockRatCage)this.func_195044_w().func_177230_c();
                if (this.useTicks > 200 && this.useTicks % 100 == 0 && this.random.nextFloat() > 0.25f) {
                    for (Direction direction : Direction.values()) {
                        if (cageBlock.canFenceConnectTo(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)), false, Direction.DOWN) != 1 || this.wheeler == null || this.field_174879_c == null) continue;
                        this.wheeler.func_70107_b((float)this.field_174879_c.func_177972_a(direction).func_177958_n() + 0.5f, (float)this.field_174879_c.func_177972_a(direction).func_177956_o() + 0.5f, (float)this.field_174879_c.func_177972_a(direction).func_177952_p() + 0.5f);
                        this.wheeler.setInWheel(false);
                        this.wheeler = null;
                        this.dismountCooldown = 1200 + this.random.nextInt(1200);
                    }
                }
            }
        } else {
            if (this.useTicks != 0) {
                this.wheelRot %= 360.0f;
                this.goalOfWheel = (float)MathHelper.func_76141_d((float)((this.wheelRot + 90.0f) / 90.0f)) * 90.0f % 360.0f;
                this.prevWheelRot = this.wheelRot % 360.0f;
            }
            this.useTicks = 0;
            if (Math.toRadians(this.wheelRot) % 90.0 == 0.0 || Math.abs(this.goalOfWheel - this.wheelRot) < 1.5f) {
                this.goalOfWheel = 0.0f;
                this.prevWheelRot = 0.0f;
                this.wheelRot = 0.0f;
            } else if (this.wheelRot > this.goalOfWheel) {
                this.wheelRot -= Math.min(wheelAdd, this.wheelRot - this.goalOfWheel);
            } else if (this.wheelRot < this.goalOfWheel) {
                this.wheelRot += Math.min(wheelAdd, this.goalOfWheel - this.wheelRot);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyStorage.cast();
        }
        return super.getCapability(capability, facing);
    }

    private boolean isEnergyFacing(Direction facing) {
        BlockState state = this.func_195044_w();
        return facing == null || state.func_177230_c() == RatsBlockRegistry.RAT_CAGE_WHEEL && (((Direction)state.func_177229_b((Property)BlockRatCageWheel.FACING)).func_176746_e() == facing || ((Direction)state.func_177229_b((Property)BlockRatCageWheel.FACING)).func_176735_f() == facing);
    }
}

