/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityRatQuarry
extends LockableTileEntity
implements ITickableTileEntity,
ISidedInventory {
    private static int[] STACKS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)64, (Object)ItemStack.field_190927_a);
    public Direction stairDirection = Direction.NORTH;

    public TileEntityRatQuarry() {
        super(RatsTileEntityRegistry.RAT_QUARRY);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public int[] func_180463_a(Direction direction) {
        return STACKS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_73660_a() {
        this.checkAndReplacePlatforms();
    }

    private void checkAndReplacePlatforms() {
        int i;
        BlockPos checkingPos = this.field_174879_c.func_177977_b();
        for (i = 0; i < this.getRadius(); ++i) {
            if (this.field_145850_b.func_175623_d(checkingPos)) {
                this.field_145850_b.func_175656_a(checkingPos, RatsBlockRegistry.RAT_QUARRY_PLATFORM.func_176223_P());
            }
            checkingPos = checkingPos.func_177972_a(Direction.NORTH);
        }
        for (i = 0; i <= this.getRadius(); ++i) {
            if (this.field_145850_b.func_175623_d(checkingPos)) {
                this.field_145850_b.func_175656_a(checkingPos, RatsBlockRegistry.RAT_QUARRY_PLATFORM.func_176223_P());
            }
            checkingPos = checkingPos.func_177972_a(Direction.WEST);
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            BlockPos checkingPos = this.field_174879_c.func_177977_b();
            for (i = 0; i < this.getRadius(); ++i) {
                if (this.field_145850_b.func_180495_p(checkingPos).func_177230_c() == RatsBlockRegistry.RAT_QUARRY_PLATFORM) {
                    this.field_145850_b.func_175655_b(checkingPos, true);
                }
                checkingPos = checkingPos.func_177972_a(Direction.NORTH);
            }
            for (i = 0; i <= this.getRadius(); ++i) {
                if (this.field_145850_b.func_180495_p(checkingPos).func_177230_c() == RatsBlockRegistry.RAT_QUARRY_PLATFORM) {
                    this.field_145850_b.func_175655_b(checkingPos, true);
                }
                checkingPos = checkingPos.func_177972_a(Direction.WEST);
            }
        }
        super.func_145843_s();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        return compound;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.rat_quarry");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new ChestContainer(ContainerType.field_221512_f, id, player, (IInventory)this, 6);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ChestContainer(ContainerType.field_221512_f, id, playerInventory, (IInventory)this, 6);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public int getRadius() {
        return 2;
    }

    public BlockPos getNextPosForStairs() {
        BlockPos stairPos = this.field_174879_c.func_177982_a(-this.getRadius(), -1, -this.getRadius());
        int passedLevels = 0;
        for (int yLevel = this.field_174879_c.func_177956_o() - 1; yLevel > 1; --yLevel) {
            boolean atLevel = false;
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)new BlockPos(this.field_174879_c.func_177958_n() - this.getRadius(), yLevel, this.field_174879_c.func_177952_p() - this.getRadius()), (BlockPos)new BlockPos(this.field_174879_c.func_177958_n() + this.getRadius(), yLevel, this.field_174879_c.func_177952_p() + this.getRadius())).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (this.field_145850_b.func_180495_p(pos).func_177230_c() != RatsBlockRegistry.RAT_QUARRY_PLATFORM) continue;
                atLevel = true;
                break;
            }
            if (!atLevel) break;
            ++passedLevels;
        }
        stairPos = stairPos.func_177979_c(passedLevels);
        Direction buildDir = Direction.SOUTH;
        for (int i = 0; i < passedLevels; ++i) {
            if (i > 0 && i % (this.getRadius() * 2) == 0) {
                buildDir = buildDir.func_176735_f();
            }
            stairPos = stairPos.func_177972_a(buildDir);
        }
        this.stairDirection = buildDir;
        return stairPos;
    }
}

