/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.events;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatlantisConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatlantisBlockRegistry;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityDemonRat;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityPlagueShot;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatMountBase;
import com.github.alexthe666.rats.server.entity.PlagueDoctorSpawner;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.items.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffRat;
import com.github.alexthe666.rats.server.message.MessageRatDismount;
import com.github.alexthe666.rats.server.message.MessageSwingArm;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rats")
public class CommonEvents {
    private static final Map<ServerWorld, PlagueDoctorSpawner> PLAGUE_DOCTOR_SPAWNER_MAP = new HashMap<ServerWorld, PlagueDoctorSpawner>();

    @SubscribeEvent
    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldItem;
        if (RatUtils.isPredator(event.getTarget()) && event.getTarget() instanceof AnimalEntity) {
            AnimalEntity ocelot = (AnimalEntity)event.getTarget();
            Item heldItem2 = event.getPlayer().func_184586_b(event.getHand()).func_77973_b();
            Random random = event.getWorld().field_73012_v;
            if (ocelot.func_110143_aJ() < ocelot.func_110138_aP()) {
                int i;
                if (heldItem2 == RatsItemRegistry.RAW_RAT) {
                    ocelot.func_70691_i(4.0f);
                    event.getWorld().func_184148_a(null, ocelot.func_226277_ct_(), ocelot.func_226278_cu_(), ocelot.func_226281_cx_(), SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    event.getWorld().func_184148_a(null, ocelot.func_226277_ct_(), ocelot.func_226278_cu_(), ocelot.func_226281_cx_(), SoundEvents.field_187636_O, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    for (i = 0; i < 3; ++i) {
                        event.getWorld().func_195594_a((IParticleData)ParticleTypes.field_197632_y, ocelot.func_226277_ct_() + random.nextDouble() - random.nextDouble(), ocelot.func_226278_cu_() + 0.5 + random.nextDouble() - random.nextDouble(), ocelot.func_226281_cx_() + random.nextDouble() - random.nextDouble(), 0.0, 0.0, 0.0);
                    }
                }
                if (heldItem2 == RatsItemRegistry.COOKED_RAT) {
                    ocelot.func_70691_i(8.0f);
                    event.getWorld().func_184148_a(null, ocelot.func_226277_ct_(), ocelot.func_226278_cu_(), ocelot.func_226281_cx_(), SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    event.getWorld().func_184148_a(null, ocelot.func_226277_ct_(), ocelot.func_226278_cu_(), ocelot.func_226281_cx_(), SoundEvents.field_187636_O, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    for (i = 0; i < 3; ++i) {
                        event.getWorld().func_195594_a((IParticleData)ParticleTypes.field_197632_y, ocelot.func_226277_ct_() + random.nextDouble() - random.nextDouble(), ocelot.func_226278_cu_() + 0.5 + random.nextDouble() - random.nextDouble(), ocelot.func_226281_cx_() + random.nextDouble() - random.nextDouble(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (event.getTarget() instanceof SheepEntity && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == Item.func_150898_a((Block)RatsBlockRegistry.DYE_SPONGE)) {
            SheepEntity sheep = (SheepEntity)event.getTarget();
            sheep.func_175512_b(DyeColor.WHITE);
            for (int i = 0; i < 8; ++i) {
                double d0 = sheep.func_70681_au().nextGaussian() * 0.02;
                double d1 = sheep.func_70681_au().nextGaussian() * 0.02;
                double d2 = sheep.func_70681_au().nextGaussian() * 0.02;
                sheep.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Item.func_150898_a((Block)RatsBlockRegistry.DYE_SPONGE))), sheep.func_226277_ct_() + (double)(sheep.func_70681_au().nextFloat() * sheep.func_213311_cf() * 2.0f) - (double)sheep.func_213311_cf(), sheep.func_226278_cu_() + (double)(sheep.func_70681_au().nextFloat() * sheep.func_213302_cg() * 2.0f) - (double)sheep.func_213302_cg(), sheep.func_226281_cx_() + (double)(sheep.func_70681_au().nextFloat() * sheep.func_213311_cf() * 2.0f) - (double)sheep.func_213311_cf(), d0, d1, d2);
            }
            sheep.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
        }
        if (event.getTarget() instanceof AbstractVillagerEntity && !(event.getTarget() instanceof EntityPlagueDoctor) && (heldItem = event.getPlayer().func_184586_b(event.getHand())).func_77973_b() == RatsItemRegistry.PLAGUE_DOCTORATE && !((AbstractVillagerEntity)event.getTarget()).func_70631_g_()) {
            AbstractVillagerEntity villager = (AbstractVillagerEntity)event.getTarget();
            EntityPlagueDoctor doctor = new EntityPlagueDoctor(RatsEntityRegistry.PLAGUE_DOCTOR, event.getWorld());
            doctor.func_82149_j((Entity)villager);
            villager.func_70106_y();
            doctor.setWillDespawn(false);
            if (!event.getWorld().field_72995_K) {
                doctor.func_213386_a((IServerWorld)event.getWorld(), event.getWorld().func_175649_E(event.getPos()), SpawnReason.MOB_SUMMONED, null, null);
                event.getWorld().func_217376_c((Entity)doctor);
            }
            doctor.func_94061_f(villager.func_175446_cd());
            if (villager.func_145818_k_()) {
                doctor.func_200203_b(villager.func_200201_e());
            }
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getPlayer().func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
        }
        if (event.getTarget() instanceof EntityPlagueDoctor && (heldItem = event.getPlayer().func_184586_b(event.getHand())).func_77973_b() == RatsItemRegistry.PLAGUE_TOME && !((EntityPlagueDoctor)event.getTarget()).func_70631_g_()) {
            EntityBlackDeath entitywitch = new EntityBlackDeath(RatsEntityRegistry.BLACK_DEATH, event.getWorld());
            entitywitch.func_70012_b(event.getTarget().func_226277_ct_(), event.getTarget().func_226278_cu_(), event.getTarget().func_226281_cx_(), event.getTarget().field_70177_z, event.getTarget().field_70125_A);
            if (!event.getTarget().field_70170_p.field_72995_K) {
                entitywitch.func_213386_a((IServerWorld)event.getTarget().func_130014_f_(), event.getTarget().field_70170_p.func_175649_E(new BlockPos(entitywitch.func_213303_ch())), SpawnReason.NATURAL, null, null);
            }
            if (event.getTarget().func_145818_k_()) {
                entitywitch.func_200203_b(event.getTarget().func_200201_e());
            }
            event.getTarget().field_70170_p.func_217376_c((Entity)entitywitch);
            event.getTarget().func_70106_y();
        }
        if (event.getPlayer().func_70644_a(RatsMod.PLAGUE_POTION) && RatConfig.plagueSpread && !(event.getTarget() instanceof EntityRat) && event.getTarget() instanceof LivingEntity && !((LivingEntity)event.getTarget()).func_70644_a(RatsMod.PLAGUE_POTION)) {
            ((LivingEntity)event.getTarget()).func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 6000));
            event.getTarget().func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
        }
    }

    public static int getProtectorCount(LivingEntity entity) {
        int protectors = 0;
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == RatlantisItemRegistry.RATLANTIS_HELMET) {
            ++protectors;
        }
        if (entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == RatlantisItemRegistry.RATLANTIS_CHESTPLATE) {
            ++protectors;
        }
        if (entity.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == RatlantisItemRegistry.RATLANTIS_LEGGINGS) {
            ++protectors;
        }
        if (entity.func_184582_a(EquipmentSlotType.FEET).func_77973_b() == RatlantisItemRegistry.RATLANTIS_BOOTS) {
            ++protectors;
        }
        return protectors;
    }

    @SubscribeEvent
    public static void onHitEntity(LivingAttackEvent event) {
        Entity trueSource;
        int protectors;
        LivingEntity attacker;
        if (event.getSource().func_76364_f() instanceof LivingEntity && RatConfig.plagueSpread && (attacker = (LivingEntity)event.getSource().func_76364_f()).func_70644_a(RatsMod.PLAGUE_POTION) && !(event.getEntityLiving() instanceof EntityRat) && !event.getEntityLiving().func_70644_a(RatsMod.PLAGUE_POTION)) {
            event.getEntityLiving().func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 6000));
            event.getEntityLiving().func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
        }
        if ((protectors = CommonEvents.getProtectorCount(event.getEntityLiving())) > 0 && event.getSource() != null && event.getSource().func_76346_g() != null && (double)(trueSource = event.getSource().func_76346_g()).func_70032_d((Entity)event.getEntityLiving()) < 6.0) {
            trueSource.func_70097_a(DamageSource.field_76376_m, 2.0f * (float)protectors);
            Vector3d vec3d = trueSource.func_213322_ci();
            double strength = 0.3 * (double)protectors;
            Vector3d vec3d1 = new Vector3d(event.getEntityLiving().func_226277_ct_() - trueSource.func_226277_ct_(), 0.0, event.getEntityLiving().func_226281_cx_() - trueSource.func_226281_cx_()).func_72432_b().func_186678_a(strength);
            trueSource.func_213293_j(vec3d.field_72450_a / 2.0 - vec3d1.field_72450_a, trueSource.func_233570_aj_() ? Math.min(0.4, vec3d.field_72448_b / 2.0 + strength) : vec3d.field_72448_b, vec3d.field_72449_c / 2.0 - vec3d1.field_72449_c);
        }
    }

    @SubscribeEvent
    public static void onPlayerPunch(AttackEntityEvent event) {
        ItemStack itemstack = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        StriderEntity strider;
        if (event.getEntity() != null && event.getEntity() instanceof IronGolemEntity && RatConfig.golemsTargetRats) {
            IronGolemEntity golem = (IronGolemEntity)event.getEntity();
            golem.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)golem, EntityRat.class, 10, false, false, RatUtils.UNTAMED_RAT_SELECTOR));
        }
        if (event.getEntity() != null && RatUtils.isPredator(event.getEntity()) && event.getEntity() instanceof AnimalEntity) {
            AnimalEntity animal = (AnimalEntity)event.getEntity();
            animal.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)animal, EntityRat.class, true));
        }
        if (RatsMod.RATLANTIS_LOADED) {
            if (event.getEntity() != null && event.getEntity() instanceof HuskEntity && ((HuskEntity)event.getEntity()).func_70681_au().nextFloat() < RatlantisConfig.archeologistHatSpawnRate) {
                event.getEntity().func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RatsItemRegistry.ARCHEOLOGIST_HAT));
            }
            if (event.getEntity() != null && event.getEntity() instanceof SkeletonEntity && ((SkeletonEntity)event.getEntity()).func_70681_au().nextFloat() < RatlantisConfig.archeologistHatSpawnRate * 0.05f) {
                event.getEntity().func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RatsItemRegistry.ARCHEOLOGIST_HAT));
            }
        }
        if (RatConfig.spawnDemonRats && event.getEntity() != null && event.getEntity() instanceof StriderEntity && event.getEntity().func_200600_R() == EntityType.field_233589_aE_ && !(strider = (StriderEntity)event.getEntity()).func_110257_ck() && strider.func_184188_bt().isEmpty() && strider.func_70681_au().nextFloat() < 0.1f && !strider.field_70170_p.field_72995_K) {
            EntityDemonRat demonRat = (EntityDemonRat)RatsEntityRegistry.DEMON_RAT.func_200721_a((World)event.getWorld());
            demonRat.func_82149_j((Entity)strider);
            event.getWorld().func_217376_c((Entity)demonRat);
            demonRat.func_184220_m((Entity)strider);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack itemstack = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
        CommonEvents.onPlayerSwing(event.getPlayer(), itemstack);
        if (event.getWorld().field_72995_K) {
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageSwingArm());
            if (event.getPlayer().func_225608_bj_() && !event.getPlayer().func_184188_bt().isEmpty()) {
                for (Entity passenger : event.getPlayer().func_184188_bt()) {
                    if (!(passenger instanceof EntityRat)) continue;
                    passenger.func_184210_p();
                    passenger.func_70107_b(event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_());
                    RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageRatDismount(passenger.func_145782_y()));
                }
            }
        }
    }

    public static void onPlayerSwing(PlayerEntity player, ItemStack heldItem) {
        if (player.field_70733_aJ == 0.0f && heldItem.func_77973_b() == RatsItemRegistry.PLAGUE_SCYTHE) {
            Multimap dmg = heldItem.func_111283_C(EquipmentSlotType.MAINHAND);
            double totalDmg = 0.0;
            for (AttributeModifier modifier : dmg.get((Object)Attributes.field_233823_f_)) {
                totalDmg += modifier.func_111164_d();
            }
            player.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
            EntityPlagueShot shot = new EntityPlagueShot(RatsEntityRegistry.PLAGUE_SHOT, player.field_70170_p, (LivingEntity)player, totalDmg * 0.5);
            Vector3d vector3d1 = player.func_213286_i(1.0f);
            Vector3d vector3d = player.func_70676_i(1.0f);
            Vector3f vector3f = new Vector3f(vector3d);
            shot.func_70186_c(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c(), 1.0f, 0.5f);
            player.field_70170_p.func_217376_c((Entity)shot);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemstack = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityIllagerPiper && event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < RatConfig.piperHatDropRate + RatConfig.piperHatDropRate / 2.0f * (float)event.getLootingLevel()) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), new ItemStack((IItemProvider)RatsItemRegistry.PIPER_HAT)));
        }
        if (RatsMod.RATLANTIS_LOADED && event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityRat) {
            int level = event.getLootingLevel();
            if (((EntityRat)event.getEntity()).func_70681_au().nextFloat() <= 2.0E-4f + (float)level * 1.0E-4f) {
                event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), new ItemStack((IItemProvider)RatlantisBlockRegistry.CHUNKY_CHEESE_TOKEN, 1)));
            }
        }
        if (event.getEntityLiving() instanceof CreeperEntity && ((CreeperEntity)event.getEntityLiving()).func_225509_J__()) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), new ItemStack((IItemProvider)RatsItemRegistry.CHARGED_CREEPER_CHUNK, event.getLootingLevel() + 1 + event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2))));
        }
        if (event.getSource().func_76346_g() instanceof EntityRat && ((EntityRat)event.getSource().func_76346_g()).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT)) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), new ItemStack((IItemProvider)RatsItemRegistry.TINY_COIN)));
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        if (event.getEntityLiving().func_70660_b(RatsMod.PLAGUE_POTION) != null) {
            EffectInstance effect = event.getEntityLiving().func_70660_b(RatsMod.PLAGUE_POTION);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            AxisAlignedBB axisalignedbb = event.getEntityLiving().func_174813_aQ().func_72314_b(RatConfig.ratVoodooDistance, RatConfig.ratVoodooDistance, RatConfig.ratVoodooDistance);
            List list = event.getEntityLiving().field_70170_p.func_217357_a(EntityRat.class, axisalignedbb);
            ArrayList<EntityRat> voodooRats = new ArrayList<EntityRat>();
            boolean capturedRat = false;
            if (!list.isEmpty()) {
                for (EntityRat rat : list) {
                    if (!rat.func_70909_n() || !rat.func_152114_e(event.getEntityLiving()) || !rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO)) continue;
                    voodooRats.add(rat);
                }
                if (!voodooRats.isEmpty()) {
                    float damage = event.getAmount() / (float)Math.max(1, voodooRats.size());
                    event.setCanceled(true);
                    for (EntityRat rat : voodooRats) {
                        rat.func_70097_a(event.getSource(), damage);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void worldLoad(WorldEvent.Load evt) {
        if (!evt.getWorld().func_201670_d() && evt.getWorld() instanceof ServerWorld) {
            PLAGUE_DOCTOR_SPAWNER_MAP.put((ServerWorld)evt.getWorld(), new PlagueDoctorSpawner((ServerWorld)evt.getWorld()));
        }
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload evt) {
        if (!evt.getWorld().func_201670_d() && evt.getWorld() instanceof ServerWorld) {
            PLAGUE_DOCTOR_SPAWNER_MAP.remove(evt.getWorld());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent tick) {
        ServerWorld serverWorld;
        PlagueDoctorSpawner spawner;
        if (!tick.world.field_72995_K && tick.world instanceof ServerWorld && (spawner = PLAGUE_DOCTOR_SPAWNER_MAP.get(serverWorld = (ServerWorld)tick.world)) != null) {
            spawner.tick();
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityRat rat;
        if (event.getTarget() instanceof EntityRatMountBase && (rat = ((EntityRatMountBase)event.getTarget()).getRat()) != null && event.getEntityLiving() instanceof IMob && rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDEAD)) {
            event.getEntityLiving().func_70604_c(null);
            if (event.getEntityLiving() instanceof MobEntity) {
                ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            }
        }
        if (event.getTarget() instanceof EntityRat) {
            rat = (EntityRat)event.getTarget();
            if (event.getEntityLiving() instanceof IMob && rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDEAD)) {
                event.getEntityLiving().func_70604_c(null);
                if (event.getEntityLiving() instanceof MobEntity) {
                    ((MobEntity)event.getEntityLiving()).func_70624_b(null);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Random rand;
        if (event.getEntityLiving().field_70170_p.field_72995_K && (event.getEntityLiving().func_70644_a(RatsMod.PLAGUE_POTION) || event.getEntityLiving() instanceof EntityRat && ((EntityRat)event.getEntityLiving()).hasPlague()) && (rand = event.getEntityLiving().func_70681_au()).nextInt(4) == 0) {
            int entitySize = 1;
            if (event.getEntityLiving().func_174813_aQ().func_72320_b() > 0.0) {
                entitySize = Math.max(1, (int)event.getEntityLiving().func_174813_aQ().func_72320_b());
            }
            for (int i = 0; i < entitySize; ++i) {
                float motionX = rand.nextFloat() * 0.1f - 0.05f;
                float motionZ = rand.nextFloat() * 0.1f - 0.05f;
                RatsMod.PROXY.addParticle("flea", event.getEntityLiving().func_226277_ct_() + (double)(rand.nextFloat() * event.getEntityLiving().func_213311_cf() * 2.0f) - (double)event.getEntityLiving().func_213311_cf(), event.getEntityLiving().func_226278_cu_() + (double)(rand.nextFloat() * event.getEntityLiving().func_213302_cg()), event.getEntityLiving().func_226281_cx_() + (double)(rand.nextFloat() * event.getEntityLiving().func_213311_cf() * 2.0f) - (double)event.getEntityLiving().func_213311_cf(), motionX, 0.0, motionZ);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer().func_184586_b(Hand.MAIN_HAND).func_77973_b() == RatsItemRegistry.CHEESE_STICK || event.getPlayer().func_184586_b(Hand.OFF_HAND).func_77973_b() == RatsItemRegistry.CHEESE_STICK) {
            event.setCanceled(true);
            RatsMod.PROXY.setCheeseStaffContext(event.getPos(), event.getFace());
            Entity rat = null;
            ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
            if (stack.func_77978_p() != null && stack.func_77978_p().func_186855_b("RatUUID") && !event.getWorld().func_201670_d() && event.getWorld() instanceof ServerWorld) {
                rat = ((ServerWorld)event.getWorld()).func_217461_a(stack.func_77978_p().func_186857_a("RatUUID"));
            }
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getWorld().field_72995_K && rat != null && rat instanceof EntityRat) {
                RatsMod.sendNonLocal(new MessageCheeseStaffRat(rat.func_145782_y(), false, true), (ServerPlayerEntity)event.getPlayer());
                EntityRat boundRat = (EntityRat)rat;
                RatsMod.PROXY.setRefrencedRat(boundRat);
                event.getPlayer().func_184609_a(event.getHand());
            }
        }
        if (RatConfig.cheesemaking && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150383_bp && RatUtils.isMilk(event.getItemStack()) && (Integer)event.getWorld().func_180495_p(event.getPos()).func_177229_b((Property)CauldronBlock.field_176591_a) == 0) {
            event.getWorld().func_175656_a(event.getPos(), RatsBlockRegistry.MILK_CAULDRON.func_176223_P());
            if (!event.getWorld().field_72995_K) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)event.getPlayer(), event.getPos(), new ItemStack((IItemProvider)RatsBlockRegistry.MILK_CAULDRON));
            }
            event.getPlayer().func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
            if (!event.getPlayer().func_184812_l_()) {
                if (event.getItemStack().func_77973_b() == Items.field_151117_aB) {
                    event.getPlayer().func_184611_a(event.getHand(), new ItemStack((IItemProvider)Items.field_151133_ar));
                } else if (RatUtils.isMilk(event.getItemStack())) {
                    LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)event.getItemStack());
                    fluidHandlerOptional.ifPresent(fluidHandler -> {
                        fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack container = fluidHandler.getContainer();
                        if (event.getItemStack() != container) {
                            event.getPlayer().func_184611_a(event.getHand(), container);
                        }
                    });
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLootTableRolled(LootTableLoadEvent event) {
    }
}

