/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemRatSack
extends Item {
    public ItemRatSack() {
        super(new Item.Properties().func_200916_a(RatsMod.TAB).func_200917_a(1));
        this.setRegistryName("rats", "rat_sack");
    }

    public static int getRatsInStack(ItemStack stack) {
        int ratCount = 0;
        if (stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Rat")) continue;
                ++ratCount;
            }
        }
        return ratCount;
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        itemStack.func_77982_d(new CompoundNBT());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int ratCount = 0;
        ArrayList<String> ratNames = new ArrayList<String>();
        if (stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                IFormattableTextComponent ratNameTag;
                if (!tagInfo.contains("Rat")) continue;
                CompoundNBT ratTag = stack.func_77978_p().func_74775_l(tagInfo);
                ++ratCount;
                String ratName = I18n.func_135052_a((String)"entity.rats.rat", (Object[])new Object[0]);
                if (!ratTag.func_74779_i("CustomName").isEmpty() && !ratTag.func_74779_i("CustomName").startsWith("TextComponent") && (ratNameTag = ITextComponent.Serializer.func_240643_a_((String)ratTag.func_74779_i("CustomName"))) != null) {
                    ratName = ratNameTag.getString();
                }
                ratNames.add(ratName);
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("item.rats.rat_sack.contains", new Object[]{ratCount}).func_240699_a_(TextFormatting.GRAY));
        if (!ratNames.isEmpty()) {
            for (int i = 0; i < ratNames.size() && i < 3; ++i) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.rats.rat_sack.contain_rat", new Object[]{ratNames.get(i)}).func_240699_a_(TextFormatting.GRAY));
            }
            if (ratNames.size() > 3) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.rats.rat_sack.and_more").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (stack.func_77973_b() == RatsItemRegistry.RAT_SACK && ItemRatSack.getRatsInStack(stack) > 0) {
            int ratCount = 0;
            if (stack.func_77978_p() != null) {
                for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                    if (!tagInfo.contains("Rat")) continue;
                    ++ratCount;
                    CompoundNBT ratTag = stack.func_77978_p().func_74775_l(tagInfo);
                    EntityRat rat = new EntityRat(RatsEntityRegistry.RAT, context.func_195991_k());
                    BlockPos offset = context.func_195995_a().func_177972_a(context.func_196000_l());
                    rat.func_70037_a(ratTag);
                    rat.func_70012_b((double)offset.func_177958_n() + 0.5, offset.func_177956_o(), (double)offset.func_177952_p() + 0.5, 0.0f, 0.0f);
                    if (context.func_195991_k().field_72995_K) continue;
                    context.func_195991_k().func_217376_c((Entity)rat);
                }
            }
            if (ratCount > 0) {
                context.func_195999_j().func_184609_a(context.func_221531_n());
                context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("entity.rats.rat.sack.release", new Object[]{ratCount}), true);
                stack.func_77982_d(new CompoundNBT());
            }
        }
        return ActionResultType.PASS;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity LivingEntity2) {
        return new ItemStack((IItemProvider)RatsItemRegistry.RAT_SACK);
    }
}

