/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRatWhistle
extends Item {
    public ItemRatWhistle() {
        super(new Item.Properties().func_200916_a(RatsMod.TAB));
        this.setRegistryName("rats", "rat_whistle");
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151042_j;
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        itemStack.func_77982_d(new CompoundNBT());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        ItemStack itemStackIn = player.func_184586_b(hand);
        player.func_184811_cZ().func_185145_a((Item)this, 5);
        float chunksize = 48 * RatConfig.ratFluteDistance;
        List list = worldIn.func_72839_b((Entity)player, new AxisAlignedBB(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.func_226277_ct_() + 1.0, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + 1.0).func_72314_b((double)chunksize, 256.0, (double)chunksize));
        Iterator itr = list.iterator();
        int ratCount = 0;
        while (itr.hasNext()) {
            BlockPos homePos;
            double dist;
            Entity entity = (Entity)itr.next();
            if (!(entity instanceof EntityRat)) continue;
            ++ratCount;
            EntityRat rat = (EntityRat)entity;
            if (rat.func_213394_dL() && (dist = Math.sqrt(rat.getRatDistanceSq((double)(homePos = rat.func_213384_dI()).func_177958_n() + 0.5, (double)homePos.func_177956_o() + 0.5, (double)homePos.func_177952_p() + 0.5))) > 2.0 && rat.canMove() && (!rat.func_70661_as().func_75492_a((double)homePos.func_177958_n() + 0.5, (double)homePos.func_177956_o() + 0.5, (double)homePos.func_177952_p() + 0.5, 1.5) || dist > 1000.0)) {
                rat.attemptTeleport((double)homePos.func_177958_n() + 0.5, (double)homePos.func_177956_o() + 1.5, (double)homePos.func_177952_p() + 0.5);
            }
            rat.resetAI();
        }
        player.func_184609_a(hand);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("item.rats.rat_flute.rat_count", new Object[]{ratCount}).func_240699_a_(TextFormatting.GRAY), true);
        worldIn.func_184133_a(player, new BlockPos(player.func_213303_ch()), RatsSoundRegistry.RAT_WHISTLE, SoundCategory.NEUTRAL, 1.0f, 1.25f);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.rats.rat_whistle.desc0").func_240699_a_(TextFormatting.GRAY));
    }
}

