/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCheeseStaffSync {
    public int entityId;
    public long posLg;
    public int facingID;
    public int control;
    public int extraData;

    public MessageCheeseStaffSync(int entityId, long pos, int facing, int control) {
        this.entityId = entityId;
        this.posLg = pos;
        this.facingID = facing;
        this.control = control;
        this.extraData = 0;
    }

    public MessageCheeseStaffSync(int entityId, BlockPos pos, Direction facing, int control) {
        this.entityId = entityId;
        this.posLg = pos.func_218275_a();
        this.facingID = facing.ordinal();
        this.control = control;
        this.extraData = 0;
    }

    public MessageCheeseStaffSync(int entityId, long pos, int facing, int control, int extraData) {
        this.entityId = entityId;
        this.posLg = pos;
        this.facingID = facing;
        this.control = control;
        this.extraData = extraData;
    }

    public MessageCheeseStaffSync(int entityId, BlockPos pos, Direction facing, int control, int extraData) {
        this.entityId = entityId;
        this.posLg = pos.func_218275_a();
        this.facingID = facing.ordinal();
        this.control = control;
        this.extraData = extraData;
    }

    public static MessageCheeseStaffSync read(PacketBuffer packetBuffer) {
        return new MessageCheeseStaffSync(packetBuffer.readInt(), packetBuffer.readLong(), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readInt());
    }

    public static void write(MessageCheeseStaffSync message, PacketBuffer buf) {
        buf.writeInt(message.entityId);
        buf.writeLong(message.posLg);
        buf.writeInt(message.facingID);
        buf.writeInt(message.control);
        buf.writeInt(message.extraData);
    }

    public static class Handler {
        public static void handle(MessageCheeseStaffSync message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity e;
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (e = player.field_70170_p.func_73045_a(message.entityId)) instanceof EntityRat) {
                    EntityRat rat = (EntityRat)e;
                    switch (message.control) {
                        case 0: {
                            rat.setDepositPos(BlockPos.func_218283_e((long)message.posLg));
                            rat.depositFacing = Direction.values()[message.facingID];
                            break;
                        }
                        case 1: {
                            rat.setPickupPos(BlockPos.func_218283_e((long)message.posLg));
                            break;
                        }
                        case 2: {
                            rat.func_213390_a(BlockPos.func_218283_e((long)message.posLg), 32);
                            break;
                        }
                        case 3: {
                            rat.func_213390_a(BlockPos.field_177992_a, -1);
                            break;
                        }
                        case 4: {
                            rat.setSearchRadiusCenter(BlockPos.func_218283_e((long)message.posLg));
                            break;
                        }
                        case 5: {
                            rat.setSearchRadius(message.extraData);
                            break;
                        }
                        case 6: {
                            rat.setSearchRadiusCenter(null);
                            rat.setSearchRadius(RatConfig.defaultRatRadius);
                            break;
                        }
                        case 7: {
                            rat.setPickupPos(null);
                            rat.setDepositPos(null);
                        }
                    }
                }
            });
        }
    }
}

