/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncRatTag {
    public int ratId;
    public CompoundNBT ratTag;

    public MessageSyncRatTag(int ratId, CompoundNBT ratTag) {
        this.ratId = ratId;
        this.ratTag = ratTag;
    }

    public static MessageSyncRatTag read(PacketBuffer buf) {
        return new MessageSyncRatTag(buf.readInt(), PacketBufferUtils.readTag((ByteBuf)buf));
    }

    public static void write(MessageSyncRatTag message, PacketBuffer buf) {
        buf.writeInt(message.ratId);
        PacketBufferUtils.writeTag((ByteBuf)buf, (CompoundNBT)message.ratTag);
    }

    public static class Handler {
        public static void handle(MessageSyncRatTag message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (player == null) {
                    player = RatsMod.PROXY.getPlayer();
                }
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.ratId)) instanceof EntityRat) {
                    EntityRat rat = (EntityRat)entity;
                    rat.func_70037_a(message.ratTag);
                }
            });
        }
    }
}

