/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe666.rats.server.entity.EntityRat;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateRatFluid {
    public int ratId;
    public FluidStack fluid;

    public MessageUpdateRatFluid() {
    }

    public MessageUpdateRatFluid(int ratId, FluidStack fluid) {
        this.ratId = ratId;
        this.fluid = fluid;
    }

    public static MessageUpdateRatFluid read(PacketBuffer buf) {
        return new MessageUpdateRatFluid(buf.readInt(), FluidStack.loadFluidStackFromNBT((CompoundNBT)PacketBufferUtils.readTag((ByteBuf)buf)));
    }

    public static void write(MessageUpdateRatFluid message, PacketBuffer buf) {
        buf.writeInt(message.ratId);
        CompoundNBT fluidTag = new CompoundNBT();
        if (message.fluid != null) {
            message.fluid.writeToNBT(fluidTag);
        }
        PacketBufferUtils.writeTag((ByteBuf)buf, (CompoundNBT)fluidTag);
    }

    public static class Handler {
        public static void handle(MessageUpdateRatFluid message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.ratId)) instanceof EntityRat) {
                    EntityRat rat = (EntityRat)entity;
                    rat.transportingFluid = message.fluid;
                }
            });
        }
    }
}

