/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.pathfinding;

import com.github.alexthe666.rats.server.pathfinding.PathFindingStatus;

public class PathResult {
    protected PathFindingStatus status = PathFindingStatus.IN_PROGRESS_COMPUTING;
    private boolean pathReachesDestination = false;
    private int pathLength = 0;

    public PathFindingStatus getStatus() {
        return this.status;
    }

    public void setStatus(PathFindingStatus s) {
        this.status = s;
    }

    public boolean isInProgress() {
        return this.isComputing() || this.status == PathFindingStatus.IN_PROGRESS_FOLLOWING;
    }

    public boolean isComputing() {
        return this.status == PathFindingStatus.IN_PROGRESS_COMPUTING;
    }

    public boolean failedToReachDestination() {
        return !this.isComputing() && !this.isPathReachingDestination();
    }

    public boolean isPathReachingDestination() {
        return this.pathReachesDestination;
    }

    public void setPathReachesDestination(boolean value) {
        this.pathReachesDestination = value;
    }

    public boolean isCancelled() {
        return this.status == PathFindingStatus.CANCELLED;
    }

    public int getPathLength() {
        return this.pathLength;
    }

    public void setPathLength(int l) {
        this.pathLength = l;
    }

    public boolean didPathGenerate() {
        return this.pathLength > 0;
    }
}

