/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.pathfinding;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.pathfinding.pathjobs.AbstractPathJob;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public final class Pathfinding {
    private static final Set<Class<?>> loadedJobs = new CopyOnWriteArraySet();
    private static final BlockingQueue<Runnable> ratsJobQueue = new LinkedBlockingDeque<Runnable>();
    private static ThreadPoolExecutor pathExecutor;

    private Pathfinding() {
    }

    public static boolean isDebug() {
        return false;
    }

    public static ThreadPoolExecutor getPathExecutor() {
        if (pathExecutor == null) {
            pathExecutor = new ThreadPoolExecutor(1, RatConfig.ratsPathfindingThreads, 0L, TimeUnit.SECONDS, ratsJobQueue, new RatsThreadFactory());
        }
        return pathExecutor;
    }

    public static void shutdown() {
        Pathfinding.getPathExecutor().shutdownNow();
        ratsJobQueue.clear();
        pathExecutor = null;
    }

    public static Future<Path> enqueue(AbstractPathJob job) {
        if (!loadedJobs.contains(job.getClass())) {
            ThreadTaskExecutor workqueue = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            CompletableFuture<Path> result = workqueue.func_213162_bc() ? CompletableFuture.completedFuture(job.call()) : CompletableFuture.supplyAsync(job::call, (Executor)workqueue);
            return result.thenApply(path -> {
                loadedJobs.add(job.getClass());
                return path;
            });
        }
        if (Pathfinding.getPathExecutor().isShutdown() || Pathfinding.getPathExecutor().isTerminating() || Pathfinding.getPathExecutor().isTerminated()) {
            return null;
        }
        return Pathfinding.getPathExecutor().submit(job);
    }

    public static class RatsThreadFactory
    implements ThreadFactory {
        public static int id;
        private static final ClassLoader classLoader;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Rats Mod Pathfinding Worker #" + id++);
            thread.setDaemon(true);
            thread.setPriority(10);
            if (thread.getContextClassLoader() != classLoader) {
                RatsMod.LOGGER.info("Corrected CCL of new Rats Pathfinding Thread, was: " + thread.getContextClassLoader().toString());
                thread.setContextClassLoader(classLoader);
            }
            thread.setUncaughtExceptionHandler((thread1, throwable) -> RatsMod.LOGGER.error("Rats Pathfinding Thread errored! ", throwable));
            return thread;
        }

        static {
            ThreadTaskExecutor workqueue = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            classLoader = workqueue.func_213162_bc() ? Thread.currentThread().getContextClassLoader() : CompletableFuture.supplyAsync(() -> Thread.currentThread().getContextClassLoader(), (Executor)workqueue).join();
        }
    }
}

