/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class PlagueDoctorWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "rats_travelling_plague_doctor";
    private World world;
    private int tickCounter;
    private int doctorSpawnDelay;
    private int doctorSpawnChance;
    private UUID doctorID;

    public PlagueDoctorWorldData() {
        super(IDENTIFIER);
    }

    public static PlagueDoctorWorldData get(World world) {
        if (world instanceof ServerWorld) {
            ServerWorld overworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            DimensionSavedDataManager storage = overworld.func_217481_x();
            PlagueDoctorWorldData data = (PlagueDoctorWorldData)storage.func_215752_a(PlagueDoctorWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.func_76185_a();
            }
            return data;
        }
        return null;
    }

    public int getDoctorSpawnDelay() {
        return this.doctorSpawnDelay;
    }

    public void setDoctorSpawnDelay(int delay) {
        this.doctorSpawnDelay = delay;
    }

    public int getDoctorSpawnChance() {
        return this.doctorSpawnChance;
    }

    public void setDoctorSpawnChance(int chance) {
        this.doctorSpawnChance = chance;
    }

    public void setPlagueDoctorID(UUID id) {
        this.doctorID = id;
    }

    public void debug() {
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("PlagueDoctorSpawnDelay", 99)) {
            this.doctorSpawnDelay = nbt.func_74762_e("PlagueDoctorSpawnDelay");
        }
        if (nbt.func_150297_b("PlagueDoctorSpawnChance", 99)) {
            this.doctorSpawnChance = nbt.func_74762_e("PlagueDoctorSpawnChance");
        }
        if (nbt.func_150297_b("PlagueDoctorId", 8)) {
            this.doctorID = UUID.fromString(nbt.func_74779_i("PlagueDoctorId"));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("PlagueDoctorSpawnDelay", this.doctorSpawnDelay);
        compound.func_74768_a("PlagueDoctorSpawnChance", this.doctorSpawnChance);
        if (this.doctorID != null) {
            compound.func_74778_a("PlagueDoctorId", this.doctorID.toString());
        }
        return compound;
    }
}

