/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches;

import com.chaosthedude.realistictorches.config.ConfigHandler;
import com.chaosthedude.realistictorches.registry.RealisticTorchesRegistry;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="realistictorches")
public class RealisticTorches {
    public static final String MODID = "realistictorches";
    public static final Logger LOGGER = LogManager.getLogger();

    public RealisticTorches() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_CONFIG);
        ConfigHandler.loadConfig(ConfigHandler.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("realistictorches-common.toml"));
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> eventBus.addListener(this::clientSetup));
        eventBus.addListener(this::buildCreativeTabContents);
        RealisticTorchesRegistry.BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        RealisticTorchesRegistry.ITEM_REGISTRY.register(eventBus);
        RealisticTorchesRegistry.BLOCK_REGISTRY.register(eventBus);
        RealisticTorchesRegistry.LOOT_CONDITION_REGISTRY.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void buildCreativeTabContents(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256869_) {
            event.m_246342_(new ItemStack((ItemLike)RealisticTorchesRegistry.MATCHBOX_ITEM.get()));
        } else if (event.getTab() == CreativeModeTabs.f_256791_) {
            event.m_246342_(new ItemStack((ItemLike)RealisticTorchesRegistry.LIT_TORCH_ITEM.get()));
        } else if (event.getTab() == CreativeModeTabs.f_256968_) {
            event.m_246342_(new ItemStack((ItemLike)RealisticTorchesRegistry.GLOWSTONE_CRYSTAL_ITEM.get()));
            event.m_246342_(new ItemStack((ItemLike)RealisticTorchesRegistry.GLOWSTONE_PASTE_ITEM.get()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RealisticTorchesRegistry.TORCH_BLOCK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RealisticTorchesRegistry.TORCH_WALL_BLOCK.get()), (RenderType)RenderType.m_110463_());
    }
}

