/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.blocks;

import com.chaosthedude.realistictorches.config.ConfigHandler;
import com.chaosthedude.realistictorches.registry.RealisticTorchesRegistry;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class RealisticTorchBlock
extends TorchBlock {
    public static final String NAME = "torch";
    public static final int TICK_INTERVAL = 1200;
    protected static final int INITIAL_BURN_TIME = (Integer)ConfigHandler.torchBurnoutTime.get();
    protected static final boolean SHOULD_BURN_OUT = INITIAL_BURN_TIME > 0;
    protected static final IntegerProperty BURNTIME = IntegerProperty.m_61631_((String)"burntime", (int)0, (int)(SHOULD_BURN_OUT ? INITIAL_BURN_TIME : 1));
    protected static final IntegerProperty LITSTATE = IntegerProperty.m_61631_((String)"litstate", (int)0, (int)2);
    public static final int LIT = 2;
    public static final int SMOLDERING = 1;
    public static final int UNLIT = 0;

    public RealisticTorchBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60953_(RealisticTorchBlock.getLightValueFromState()), (ParticleOptions)ParticleTypes.f_123744_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LITSTATE, (Comparable)Integer.valueOf(0))).m_61124_((Property)BURNTIME, (Comparable)Integer.valueOf(0)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)LITSTATE) == 2 || (Integer)state.m_61143_((Property)LITSTATE) == 1 && level.m_213780_().m_188503_(2) == 1) {
            super.m_214162_(state, level, pos, random);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42409_ || stack.m_41720_() == RealisticTorchesRegistry.MATCHBOX_ITEM.get() || ((List)ConfigHandler.lightTorchItems.get()).contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString())) {
            this.playLightingSound(level, pos);
            if (!(player.m_7500_() || stack.m_41720_() == RealisticTorchesRegistry.MATCHBOX_ITEM.get() && (Integer)ConfigHandler.matchboxDurability.get() <= 0)) {
                stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
            }
            if (level.m_46758_(pos)) {
                this.playExtinguishSound(level, pos);
            } else {
                this.changeToLit(level, pos, state);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.m_5776_() && SHOULD_BURN_OUT && (Integer)state.m_61143_((Property)LITSTATE) > 0) {
            if (level.m_46758_(pos)) {
                this.playExtinguishSound((Level)level, pos);
                this.changeToUnlit((Level)level, pos, state);
                return;
            }
            int newBurnTime = (Integer)state.m_61143_((Property)BURNTIME) - 1;
            if (newBurnTime <= 0) {
                this.playExtinguishSound((Level)level, pos);
                this.changeToUnlit((Level)level, pos, state);
                level.m_46672_(pos, (Block)this);
            } else if ((Integer)state.m_61143_((Property)LITSTATE) == 2 && (newBurnTime <= INITIAL_BURN_TIME / 10 || newBurnTime <= 1)) {
                this.changeToSmoldering((Level)level, pos, state, newBurnTime);
                level.m_46672_(pos, (Block)this);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BURNTIME, (Comparable)Integer.valueOf(newBurnTime)), 2);
                level.m_186460_(pos, (Block)this, 1200);
            }
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        level.m_186460_(pos, (Block)this, 1200);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            this.m_49966_().m_60701_((LevelAccessor)level, pos, 3);
        }
        super.m_6807_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BURNTIME});
        builder.m_61104_(new Property[]{LITSTATE});
    }

    public static IntegerProperty getBurnTime() {
        return BURNTIME;
    }

    public static IntegerProperty getLitState() {
        return LITSTATE;
    }

    public static int getInitialBurnTime() {
        return SHOULD_BURN_OUT ? INITIAL_BURN_TIME : 0;
    }

    public void changeToLit(Level Level2, BlockPos pos, BlockState state) {
        Level2.m_7731_(pos, (BlockState)((BlockState)((Block)RealisticTorchesRegistry.TORCH_BLOCK.get()).m_49966_().m_61124_((Property)LITSTATE, (Comparable)Integer.valueOf(2))).m_61124_((Property)BURNTIME, (Comparable)Integer.valueOf(RealisticTorchBlock.getInitialBurnTime())), 2);
        if (SHOULD_BURN_OUT) {
            Level2.m_186460_(pos, (Block)this, 1200);
        }
    }

    public void changeToSmoldering(Level level, BlockPos pos, BlockState state, int newBurnTime) {
        if (SHOULD_BURN_OUT) {
            level.m_7731_(pos, (BlockState)((BlockState)((Block)RealisticTorchesRegistry.TORCH_BLOCK.get()).m_49966_().m_61124_((Property)LITSTATE, (Comparable)Integer.valueOf(1))).m_61124_((Property)BURNTIME, (Comparable)Integer.valueOf(newBurnTime)), 2);
            level.m_186460_(pos, (Block)this, 1200);
        }
    }

    public void changeToUnlit(Level level, BlockPos pos, BlockState state) {
        if (SHOULD_BURN_OUT) {
            if (((Boolean)ConfigHandler.noRelightEnabled.get()).booleanValue()) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            } else {
                level.m_7731_(pos, ((Block)RealisticTorchesRegistry.TORCH_BLOCK.get()).m_49966_(), 2);
                level.m_186460_(pos, (Block)this, 1200);
            }
        }
    }

    public void playLightingSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public void playExtinguishSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    private static ToIntFunction<BlockState> getLightValueFromState() {
        return state -> {
            if ((Integer)state.m_61143_((Property)LITSTATE) == 2) {
                return 14;
            }
            if ((Integer)state.m_61143_((Property)LITSTATE) == 1) {
                return 12;
            }
            return 0;
        };
    }
}

