/*
 * Decompiled with CFR 0.152.
 */
package mc.rpgstats.main;

import com.mojang.brigadier.CommandDispatcher;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import mc.rpgstats.advancemnents.AdvancementHelper;
import mc.rpgstats.command.CheatCommand;
import mc.rpgstats.command.StatsCommand;
import mc.rpgstats.component.IStatComponent;
import mc.rpgstats.event.LevelUpCallback;
import mc.rpgstats.main.RPGStatsConfig;
import mc.rpgstats.main.StatComponents;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RPGStats
implements ModInitializer {
    public static final String MOD_ID = "rpgstats";
    public static final class_2960 SYNC_STATS_PACKET_ID = new class_2960("rpgstats", "sync_stats");
    public static final class_2960 OPEN_GUI = new class_2960("rpgstats", "open_gui");
    public static ArrayList<class_3222> needsStatFix = new ArrayList();
    public static RPGStatsConfig configUnsafe;
    private int tickCount = 0;

    public void onInitialize() {
        System.out.println("RPGStats is starting...");
        AutoConfig.register(RPGStatsConfig.class, JanksonConfigSerializer::new);
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            StatsCommand.register((CommandDispatcher<class_2168>)dispatcher);
            CheatCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ++this.tickCount;
            if (this.tickCount >= 20) {
                Collection collection = server.method_3851().method_12893();
                PlayerLookup.all((MinecraftServer)server).forEach(player -> {
                    if (needsStatFix.contains(player) && player.method_5805()) {
                        RPGStats.softLevelUp(StatComponents.DEFENSE_COMPONENT, player);
                        RPGStats.softLevelUp(StatComponents.FARMING_COMPONENT, player);
                        RPGStats.softLevelUp(StatComponents.MAGIC_COMPONENT, player);
                        RPGStats.softLevelUp(StatComponents.MELEE_COMPONENT, player);
                        RPGStats.softLevelUp(StatComponents.MINING_COMPONENT, player);
                        RPGStats.softLevelUp(StatComponents.RANGED_COMPONENT, player);
                        RPGStats.softLevelUp(StatComponents.FISHING_COMPONENT, player);
                        needsStatFix.remove(player);
                    }
                    for (class_161 advancement : collection) {
                        if (!advancement.method_688().method_12836().equals(MOD_ID) || player.method_14236().method_12882(advancement).method_740() || !AdvancementHelper.shouldGrant(advancement.method_688(), player)) continue;
                        player.method_14236().method_12878(advancement, "trigger");
                    }
                    if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)SYNC_STATS_PACKET_ID)) {
                        int count = StatComponents.statList.size();
                        class_2540 passedData = new class_2540(Unpooled.buffer());
                        passedData.writeInt(count);
                        for (class_2960 statIdent : StatComponents.idToComponentIndexMap.keySet()) {
                            passedData.method_10812(statIdent);
                            ComponentKey<? extends IStatComponent> stat = RPGStats.statFromID(statIdent);
                            passedData.writeInt(RPGStats.getComponentLevel(stat, player));
                            passedData.writeInt(RPGStats.getComponentXP(stat, player));
                        }
                        ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC_STATS_PACKET_ID, (class_2540)passedData);
                    }
                    if (player.method_24515().method_10264() <= 40 && RPGStats.getComponentLevel(StatComponents.MINING_COMPONENT, player) >= 50) {
                        player.method_6092(new class_1293(class_1294.field_5925, 260));
                        player.method_6092(new class_1293(class_1294.field_5917, 40, 1));
                    }
                });
                this.tickCount = 0;
            }
        });
        System.out.println("RPGStats is done loading");
    }

    public static void setComponentXP(ComponentKey<? extends IStatComponent> type, class_3222 player, int newValue) {
        ((IStatComponent)type.get((Object)player)).setXP(newValue);
    }

    public static int getComponentXP(ComponentKey<? extends IStatComponent> type, class_3222 player) {
        return ((IStatComponent)type.get((Object)player)).getXP();
    }

    public static void setComponentLevel(ComponentKey<? extends IStatComponent> type, class_3222 player, int newValue) {
        ((IStatComponent)type.get((Object)player)).setLevel(newValue);
    }

    public static int getComponentLevel(ComponentKey<? extends IStatComponent> type, class_3222 player) {
        return ((IStatComponent)type.get((Object)player)).getLevel();
    }

    public static int calculateXpNeededToReachLevel(int level) {
        RPGStatsConfig config = RPGStats.getConfig();
        return (int)Math.floor(Math.pow(level, config.scaling.power) * config.scaling.scale) + config.scaling.base;
    }

    public static void addXpAndLevelUp(ComponentKey<? extends IStatComponent> type, class_3222 player, int addedXP) {
        int currentLevel = RPGStats.getComponentLevel(type, player);
        if (currentLevel < 50) {
            int nextXP;
            int nextXPForLevelUp = RPGStats.calculateXpNeededToReachLevel(currentLevel + 1);
            for (nextXP = RPGStats.getComponentXP(type, player) + addedXP; nextXP >= nextXPForLevelUp && currentLevel < 50; nextXP -= nextXPForLevelUp) {
                RPGStats.setComponentLevel(type, player, ++currentLevel);
                ((class_1657)((IStatComponent)type.get((Object)player)).getEntity()).method_7353((class_2561)new class_2585("\u00a7aRPGStats >\u00a7r You gained a \u00a76" + ((IStatComponent)type.get((Object)player)).getName() + "\u00a7r level! You are now level \u00a76" + ((IStatComponent)type.get((Object)player)).getLevel()), false);
                ((IStatComponent)type.get((Object)player)).onLevelUp(false);
                ((LevelUpCallback)LevelUpCallback.EVENT.invoker()).onLevelUp((class_1657)player, type, currentLevel);
                nextXPForLevelUp = RPGStats.calculateXpNeededToReachLevel(currentLevel + 1);
            }
            RPGStats.setComponentXP(type, player, nextXP);
        }
    }

    public static String getFormattedLevelData(ComponentKey<? extends IStatComponent> type, class_3222 player) {
        int currentLevel = RPGStats.getComponentLevel(type, player);
        int xp = RPGStats.getComponentXP(type, player);
        if (currentLevel < 50) {
            int nextXP = RPGStats.calculateXpNeededToReachLevel(currentLevel + 1);
            return "\u00a76" + ((IStatComponent)type.get((Object)player)).getCapName() + "\u00a7r - Level: " + currentLevel + " XP: " + xp + "/" + nextXP;
        }
        return "\u00a76" + ((IStatComponent)type.get((Object)player)).getCapName() + "\u00a7r - Level: " + currentLevel;
    }

    public static String getNotFormattedLevelData(ComponentKey<? extends IStatComponent> type, class_3222 player) {
        int currentLevel = RPGStats.getComponentLevel(type, player);
        int xp = RPGStats.getComponentXP(type, player);
        if (currentLevel < 50) {
            int nextXP = RPGStats.calculateXpNeededToReachLevel(currentLevel + 1);
            return ((IStatComponent)type.get((Object)player)).getCapName() + " - Level: " + currentLevel + " XP: " + xp + "/" + nextXP;
        }
        return "" + ((IStatComponent)type.get((Object)player)).getCapName() + " - Level: " + currentLevel;
    }

    public static ArrayList<Integer> getStatLevelsForPlayer(class_3222 player) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (ComponentKey<? extends IStatComponent> stat : StatComponents.statList) {
            result.add(RPGStats.getComponentLevel(stat, player));
        }
        return result;
    }

    public static int getHighestLevel(class_3222 player) {
        return Collections.max(RPGStats.getStatLevelsForPlayer(player));
    }

    public static int getLowestLevel(class_3222 player) {
        return Collections.min(RPGStats.getStatLevelsForPlayer(player));
    }

    public static void softLevelUp(ComponentKey<? extends IStatComponent> type, class_3222 player) {
        int savedLevel = RPGStats.getComponentLevel(type, player);
        if (savedLevel > 50) {
            RPGStats.setComponentLevel(type, player, 50);
            RPGStats.setComponentXP(type, player, 0);
            savedLevel = 50;
        }
        for (int i = 1; i <= savedLevel; ++i) {
            RPGStats.setComponentLevel(type, player, i);
            ((IStatComponent)type.get((Object)player)).onLevelUp(true);
        }
    }

    public static ComponentKey<? extends IStatComponent> statFromID(class_2960 ID) {
        return StatComponents.statList.get(StatComponents.idToComponentIndexMap.get(ID));
    }

    public static RPGStatsConfig getConfig() {
        if (configUnsafe == null) {
            configUnsafe = (RPGStatsConfig)AutoConfig.getConfigHolder(RPGStatsConfig.class).getConfig();
        }
        return configUnsafe;
    }
}

