/*
 * Decompiled with CFR 0.152.
 */
package com.drewchaseproject.minecraft.forge.SimpleSorting.Handlers;

import com.drewchaseproject.minecraft.forge.SimpleSorting.GUI.ContainerContext;
import com.drewchaseproject.minecraft.forge.SimpleSorting.Handlers.ItemStackHolder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public enum InventoryHandler {
    INSTANCE;

    public final Method mergeStack = this.getMergeStackMethod();
    public static Map<IInventory, ImmutableList<IInventory>> preferredOrders;

    private Method getMergeStackMethod() {
        Method m = ObfuscationReflectionHelper.findMethod(Container.class, (String)"func_75135_a", (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
        m.setAccessible(true);
        return m;
    }

    public boolean mergeStack(Container container, ItemStack stack, int low, int high, boolean rev) {
        try {
            return (Boolean)this.mergeStack.invoke((Object)container, stack, low, high, rev);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack getItemStack(ContainerContext ctx) {
        return this.getItemStack(ctx.slot);
    }

    public ItemStack getItemStack(Slot slot) {
        if (slot.getSlotIndex() < 0) {
            return ItemStack.field_190927_a;
        }
        return slot.func_75211_c();
    }

    public void moveItemToOtherInventory(ContainerContext ctx, ItemStack is, int targetLow, int targetHigh, boolean slotIsDestination) {
        for (int i = 0; !(i >= targetHigh || ctx.player.field_71070_bA.func_75139_a(i).func_75214_a(is) && this.mergeStack(ctx.player.field_71070_bA, is, i, i + 1, slotIsDestination)); ++i) {
        }
    }

    public Slot findStackWithItem(ItemStack is, ContainerContext ctx) {
        if (is.func_77976_d() == 1) {
            return null;
        }
        List<Map.Entry<IInventory, InventoryMapping>> entries = this.getSortedMapping(ctx);
        for (Map.Entry<IInventory, InventoryMapping> ent : entries) {
            IInventory inv = ent.getKey();
            if (inv == ctx.slotMapping.inv) continue;
            for (int i = ent.getValue().begin; i <= ent.getValue().end; ++i) {
                ItemStack sis;
                Slot slot = ctx.player.field_71070_bA.func_75139_a(i);
                if (!slot.func_82869_a((PlayerEntity)ctx.player) || (sis = slot.func_75211_c()) == null || sis.func_77973_b() != is.func_77973_b() || !ItemStack.func_77970_a((ItemStack)sis, (ItemStack)is)) continue;
                return slot;
            }
        }
        return null;
    }

    public List<Map.Entry<IInventory, InventoryMapping>> getSortedMapping(ContainerContext ctx) {
        ArrayList entries = Lists.newArrayList((Iterable)ctx.mapping.entrySet());
        if (preferredOrders.containsKey(ctx.slotMapping.inv)) {
            Collections.sort(entries, (o1, o2) -> {
                int idx1 = preferredOrders.get(ctx.slotMapping.inv).indexOf(o1.getKey());
                int idx2 = preferredOrders.get(ctx.slotMapping.inv).indexOf(o2.getKey());
                return Ints.compare((int)idx1, (int)idx2);
            });
        }
        return entries;
    }

    public Multiset<ItemStackHolder> getInventoryContent(ContainerContext context) {
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        TreeMultiset itemcounts = TreeMultiset.create((Comparator)new ItemStackComparator());
        for (int i = slotLow; i < slotHigh; ++i) {
            ItemStack stack;
            Slot slot = context.player.field_71070_bA.func_75139_a(i);
            if (!slot.func_82869_a((PlayerEntity)context.player) || (stack = slot.func_75211_c()).func_190926_b()) continue;
            ItemStackHolder ish = new ItemStackHolder(stack.func_77946_l());
            itemcounts.add((Object)ish, stack.func_190916_E());
        }
        HashMultiset entries = HashMultiset.create();
        for (Multiset.Entry entry : itemcounts.descendingMultiset().entrySet()) {
            entries.add(entry.getElement(), entry.getCount());
        }
        return entries;
    }

    static {
        preferredOrders = ImmutableMap.of((Object)ContainerContext.PLAYER_HOTBAR, (Object)ImmutableList.of((Object)ContainerContext.PLAYER_OFFHAND, (Object)ContainerContext.PLAYER_MAIN), (Object)ContainerContext.PLAYER_OFFHAND, (Object)ImmutableList.of((Object)ContainerContext.PLAYER_HOTBAR, (Object)ContainerContext.PLAYER_MAIN), (Object)ContainerContext.PLAYER_MAIN, (Object)ImmutableList.of((Object)ContainerContext.PLAYER_OFFHAND, (Object)ContainerContext.PLAYER_HOTBAR));
    }

    public static class InventoryMapping {
        public int begin = Integer.MAX_VALUE;
        public int end = 0;
        public final IInventory inv;
        public final IInventory proxy;
        public final Container container;
        public final Class<? extends Slot> slotType;
        public boolean markForRemoval;
        public boolean markAsHeterogeneous;

        public InventoryMapping(IInventory inv, Container container, IInventory proxy, Class<? extends Slot> slotType) {
            this.inv = inv;
            this.container = container;
            this.proxy = proxy;
            this.slotType = slotType;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("i", (Object)this.inv).add("c", (Object)this.container).add("b", this.begin).add("e", this.end).toString();
        }

        public void addSlot(Slot sl) {
            if (!(this.slotType == sl.getClass() || this.inv instanceof PlayerInventory || this.inv instanceof FurnaceTileEntity || this.inv instanceof BrewingStandTileEntity)) {
                this.markForRemoval = true;
            }
            if (this.slotType != sl.getClass()) {
                this.markAsHeterogeneous = true;
            }
            this.begin = Math.min(sl.field_75222_d, this.begin);
            this.end = Math.max(sl.field_75222_d, this.end);
        }
    }

    public static class ItemStackComparator
    implements Comparator<ItemStackHolder> {
        @Override
        public int compare(ItemStackHolder o1, ItemStackHolder o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.is == o2.is) {
                return 0;
            }
            if (o1.is.func_77973_b() != o2.is.func_77973_b()) {
                return String.valueOf(o1.is.func_77973_b().getRegistryName()).compareTo(String.valueOf(o2.is.func_77973_b().getRegistryName()));
            }
            if (ItemStack.func_77970_a((ItemStack)o1.is, (ItemStack)o2.is)) {
                return 0;
            }
            return Ints.compare((int)System.identityHashCode(o1.is), (int)System.identityHashCode(o2.is));
        }
    }
}

