/*
 * Decompiled with CFR 0.152.
 */
package com.drewchaseproject.minecraft.forge.SimpleSorting.Handlers;

import com.drewchaseproject.minecraft.forge.SimpleSorting.GUI.ContainerContext;
import com.drewchaseproject.minecraft.forge.SimpleSorting.Lists.Action;
import com.drewchaseproject.minecraft.forge.SimpleSorting.Networking.Network;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyHandler {
    private static KeyHandler keyHandler;
    private final Map<KeyBinding, Action> keyBindingMap;

    public KeyHandler() {
        InputMappings.Type.MOUSE.func_197944_a(99);
        InputMappings.Type.MOUSE.func_197944_a(101);
        this.keyBindingMap = Stream.of(Action.values()).map(a -> new AbstractMap.SimpleEntry<Action, KeyBinding>((Action)((Object)a), new KeyBinding(a.getKeyBindingName(), (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.MOUSE, a.getDefaultKeyCode(), "keygroup.simplesorter"))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.keyBindingMap.keySet().forEach(ClientRegistry::registerKeyBinding);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onKey);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onMouse);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onScroll);
    }

    public static void init() {
        keyHandler = new KeyHandler();
    }

    private void onKey(GuiScreenEvent.KeyboardKeyPressedEvent.Pre evt) {
        this.onInputEvent(evt, this::keyEvaluate);
    }

    private void onMouse(GuiScreenEvent.MouseClickedEvent.Pre evt) {
        this.onInputEvent(evt, this::mouseClickEvaluate);
    }

    private void onScroll(GuiScreenEvent.MouseScrollEvent.Post evt) {
        this.onInputEvent(evt, this::mouseScrollEvaluate);
    }

    private boolean keyEvaluate(KeyBinding kb, GuiScreenEvent.KeyboardKeyPressedEvent.Pre evt) {
        return kb.func_197976_a(evt.getKeyCode(), evt.getScanCode());
    }

    private boolean mouseClickEvaluate(KeyBinding kb, GuiScreenEvent.MouseClickedEvent.Pre evt) {
        return kb.func_197984_a(evt.getButton());
    }

    private boolean mouseScrollEvaluate(KeyBinding kb, GuiScreenEvent.MouseScrollEvent.Post evt) {
        int dir = (int)Math.signum(evt.getScrollDelta());
        int keycode = dir + 100;
        return kb.func_197984_a(keycode);
    }

    private <T extends GuiScreenEvent> void onInputEvent(T evt, BiPredicate<KeyBinding, T> kbTest) {
        Screen gui = evt.getGui();
        if (!(gui instanceof ContainerScreen) || gui instanceof CreativeScreen) {
            return;
        }
        ContainerScreen guiContainer = (ContainerScreen)gui;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (!ContainerContext.validSlot(slot)) {
            return;
        }
        Optional<Action> action = this.keyBindingMap.entrySet().stream().filter(e -> kbTest.test((KeyBinding)e.getKey(), evt)).map(Map.Entry::getValue).findFirst();
        if (!action.isPresent()) {
            return;
        }
        Action triggeredAction = action.get();
        if (triggeredAction.isActive() && guiContainer.func_212873_a_() != null && guiContainer.func_212873_a_().field_75151_b != null && guiContainer.func_212873_a_().field_75151_b.contains(slot)) {
            Network.channel.sendToServer((Object)triggeredAction.message(slot));
            evt.setCanceled(true);
        }
    }
}

