/*
 * Decompiled with CFR 0.152.
 */
package com.drewchaseproject.minecraft.forge.SimpleSorting;

import com.drewchaseproject.minecraft.forge.SimpleSorting.Commands.SimpleSortingCommand;
import com.drewchaseproject.minecraft.forge.SimpleSorting.Configuration.Config;
import com.drewchaseproject.minecraft.forge.SimpleSorting.Handlers.KeyHandler;
import com.drewchaseproject.minecraft.forge.SimpleSorting.Networking.Network;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simple_sorter")
public class Main {
    public static Main INSTANCE;
    public static final Logger LOGGER;
    public ResourceLocation lastContainerType;
    public boolean debugLog;
    public final Set<String> slotblacklist = new HashSet<String>();
    public final Set<ResourceLocation> containerblacklist = new HashSet<ResourceLocation>();
    public boolean configLoaded = false;

    public Main() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::preinit);
        bus.addListener(this::clientSetup);
        bus.addListener(this::handleimc);
        bus.addListener(this::onConfigLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        KeyHandler.init();
    }

    private void handleimc(InterModProcessEvent evt) {
        Stream imc = InterModComms.getMessages((String)"");
        imc.forEach(this::handleimcmessage);
    }

    private void handleimcmessage(InterModComms.IMCMessage msg) {
        ResourceLocation slotContainerTarget;
        String slotBlacklistTarget;
        if ("slotblacklist".equals(msg.getMethod()) && this.slotblacklist.add(slotBlacklistTarget = (String)msg.getMessageSupplier().get())) {
            this.debugLog("SlotBlacklist added {}", () -> new String[]{slotBlacklistTarget});
        }
        if ("containerblacklist".equals(msg.getMethod()) && this.containerblacklist.add(slotContainerTarget = (ResourceLocation)msg.getMessageSupplier().get())) {
            this.debugLog("ContainerBlacklist added {}", () -> new String[]{slotContainerTarget.toString()});
        }
        this.updateConfig();
    }

    private void updateConfig() {
        if (!this.configLoaded) {
            return;
        }
        Config.CONFIG.containerBlacklist.set(this.containerblacklist.stream().map(Objects::toString).collect(Collectors.toList()));
        Config.CONFIG.slotBlacklist.set(new ArrayList<String>(this.slotblacklist));
    }

    private void preinit(FMLCommonSetupEvent evt) {
        Network.init();
    }

    private void onServerStarting(FMLServerStartingEvent evt) {
        SimpleSortingCommand.register((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }

    void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        this.slotblacklist.clear();
        this.slotblacklist.addAll((Collection)Config.CONFIG.slotBlacklist.get());
        this.containerblacklist.clear();
        this.containerblacklist.addAll(((List)Config.CONFIG.containerBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet()));
    }

    public boolean wheelModConflicts() {
        return ModList.get().isLoaded("mousetweaks");
    }

    public boolean sortingModConflicts() {
        return false;
    }

    public final void debugLog(String message, Supplier<String[]> args) {
        if (this.debugLog) {
            LOGGER.error(message, (Object[])args.get());
        }
    }

    private static StringTextComponent greenText(String string) {
        StringTextComponent tcs = new StringTextComponent(string);
        tcs.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return tcs;
    }

    public static int blackListAdd(CommandContext<CommandSource> context) {
        ResourceLocation containerType = SimpleSortingCommand.Arguments.CONTAINER.get(context);
        if (ForgeRegistries.CONTAINERS.containsKey(containerType)) {
            Main.INSTANCE.containerblacklist.add(containerType);
            INSTANCE.updateConfig();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.bladd.message", new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.badtype", new Object[]{containerType}), true);
        return 0;
    }

    public static int blackListRemove(CommandContext<CommandSource> context) {
        ResourceLocation containerType = SimpleSortingCommand.Arguments.BLACKLISTED.get(context);
        if (ForgeRegistries.CONTAINERS.containsKey(containerType) && Main.INSTANCE.containerblacklist.remove(containerType)) {
            INSTANCE.updateConfig();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.blremove.message", new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.badtype", new Object[]{containerType}), true);
        return 0;
    }

    public static int showLast(CommandContext<CommandSource> context) {
        if (Main.INSTANCE.lastContainerType != null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.showlast.message", new Object[]{Main.INSTANCE.lastContainerType}), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.showlast.nosort", new Object[0]), true);
        }
        return 0;
    }

    public static int showBlacklist(CommandContext<CommandSource> context) {
        if (Main.INSTANCE.containerblacklist.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.showblacklist.empty", new Object[0]), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.showblacklist.message", new Object[]{Main.listBlacklist().collect(Collectors.toList())}), true);
        }
        return 0;
    }

    public static Stream<String> listContainers() {
        return ForgeRegistries.CONTAINERS.getEntries().stream().map(e -> ((ResourceLocation)e.getKey()).toString());
    }

    public static Stream<String> listBlacklist() {
        return Main.INSTANCE.containerblacklist.stream().map(Object::toString);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

