/*
 * Decompiled with CFR 0.152.
 */
package com.drewchaseproject.minecraft.forge.SimpleSorting.Commands;

import com.drewchaseproject.minecraft.forge.SimpleSorting.Main;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.jodah.typetools.TypeResolver;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.loading.StringUtils;

public class SimpleSortingCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder invsorterBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"ssort").requires(cs -> cs.func_197034_c(1));
        Stream.of(CommandAction.values()).forEach(a -> invsorterBuilder.then(a.getCommand()));
        invsorterBuilder.executes(SimpleSortingCommand::help);
        dispatcher.register(invsorterBuilder);
    }

    private static int help(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("simplesorter.commands.simplesorter.usage"));
        return 0;
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> action, Runnable emptyAction) {
        if (optional.isPresent()) {
            action.accept(optional.get());
        } else {
            emptyAction.run();
        }
    }

    private static enum CommandAction {
        BLADD(Main::blackListAdd, 1, Arguments.CONTAINER),
        BLREMOVE(Main::blackListRemove, 4, Arguments.BLACKLISTED),
        SHOWLAST(Main::showLast, 1, new TypedArgumentHandler[0]),
        LIST(Main::showBlacklist, 1, new TypedArgumentHandler[0]);

        private final int permissionLevel;
        private final ToIntFunction<CommandContext<CommandSource>> action;
        private final List<TypedArgumentHandler<?>> argumentSupplier;

        private CommandAction(ToIntFunction<CommandContext<CommandSource>> action, int permissionLevel, TypedArgumentHandler<?> ... argumentSupplier) {
            this.action = action;
            this.permissionLevel = permissionLevel;
            this.argumentSupplier = Arrays.asList(argumentSupplier);
        }

        private void addArguments(LiteralArgumentBuilder<CommandSource> builder) {
            Optional<ArgumentBuilder> argBuilder = this.argumentSupplier.stream().map(TypedArgumentHandler::build).reduce(ArgumentBuilder::then);
            SimpleSortingCommand.ifPresentOrElse(argBuilder, b -> builder.then(b.executes(this.action::applyAsInt)), () -> builder.executes(this.action::applyAsInt));
        }

        public LiteralArgumentBuilder<CommandSource> getCommand() {
            LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.func_197057_a((String)StringUtils.toLowerCase((String)this.name())).requires(cs -> cs.func_197034_c(this.permissionLevel));
            this.addArguments((LiteralArgumentBuilder<CommandSource>)base);
            return base;
        }
    }

    public static class ContainerClassArgument
    implements ArgumentType<ResourceLocation> {
        private static final List<String> EXAMPLES = Collections.singletonList("minecraft:chest");
        private final Supplier<Stream<String>> containerSuggestions;

        ContainerClassArgument(Supplier<Stream<String>> suggestions) {
            this.containerSuggestions = suggestions;
        }

        public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
            return ResourceLocation.func_195826_a((StringReader)reader);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(this.containerSuggestions.get(), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class TypedArgumentHandler<T> {
        private final String argName;
        private final ArgumentType<T> argumentType;
        private final Class<T> clazz;

        TypedArgumentHandler(String argName, Supplier<? extends ArgumentType<T>> argumentType) {
            this.argName = argName;
            this.argumentType = argumentType.get();
            Class[] classes = TypeResolver.resolveRawArguments(ArgumentType.class, this.argumentType.getClass());
            this.clazz = classes[0];
        }

        public static <A> TypedArgumentHandler<A> of(String argumentName, Supplier<? extends ArgumentType<A>> supplier) {
            return new TypedArgumentHandler(argumentName, supplier);
        }

        public RequiredArgumentBuilder<CommandSource, T> build() {
            return Commands.func_197056_a((String)this.argName, this.argumentType);
        }

        public T get(CommandContext<CommandSource> context) {
            return (T)context.getArgument(this.argName, this.clazz);
        }
    }

    public static class Arguments {
        public static final TypedArgumentHandler<ResourceLocation> CONTAINER = new TypedArgumentHandler("container", () -> new ContainerClassArgument(Main::listContainers));
        public static final TypedArgumentHandler<ResourceLocation> BLACKLISTED = new TypedArgumentHandler("blacklisted", () -> new ContainerClassArgument(Main::listBlacklist));
    }
}

