/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.skiing.common.entity;

import com.affehund.skiing.common.item.SkisItem;
import com.affehund.skiing.core.data.gen.ModTags;
import com.affehund.skiing.core.init.ModEntities;
import com.affehund.skiing.core.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SkisEntity
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(SkisEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(SkisEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(SkisEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STEP_COOLDOWN = EntityDataManager.func_187226_a(SkisEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(SkisEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SKIS_TYPE = EntityDataManager.func_187226_a(SkisEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private boolean boostDown;
    private boolean flyDown;
    private Status status;

    public SkisEntity(EntityType<SkisEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 1.0f;
        this.field_70156_m = true;
    }

    public SkisEntity(World world, double x, double y, double z) {
        this((EntityType<SkisEntity>)((EntityType)ModEntities.SKI_ENTITY.get()), world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(STEP_COOLDOWN, (Object)0);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SKIS_TYPE, (Object)SkisType.ACACIA.ordinal());
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger) || passenger instanceof PlayerEntity) {
            passenger.func_213301_b(Pose.STANDING);
            float f = -0.25f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            Vector3d vector3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
        }
    }

    protected void func_184200_o(@Nonnull Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.forwardInputDown = false;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    protected void func_184225_p(@Nonnull Entity passenger) {
        super.func_184225_p(passenger);
        this.forwardInputDown = false;
        this.backInputDown = false;
        this.rightInputDown = false;
        this.leftInputDown = false;
        this.deltaRotation = 0.0f;
        this.field_70180_af.func_187227_b(FLYING, (Object)false);
    }

    public void func_70071_h_() {
        this.updateStatus();
        if (this.field_70122_E) {
            this.field_70180_af.func_187227_b(FLYING, (Object)false);
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.tickLerp();
        if (this.func_184186_bw()) {
            this.controlEntity();
            this.updateMotion();
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_145775_I();
    }

    private void controlEntity() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                f += this.boostDown && (Boolean)this.field_70180_af.func_187225_a(FLYING) == false && this.field_70122_E ? 0.06f : 0.04f;
                if (this.status == Status.ON_SNOW) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.5, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
                }
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            if (this.flyDown && this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_189985_c() > 0.16000000000000003) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.75, 0.0));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.8, 1.0, 0.8));
                this.field_70180_af.func_187227_b(FLYING, (Object)true);
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            }
        }
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private boolean isHoldingSkiSticks(Entity ridingEntity) {
        PlayerEntity playerEntity;
        return ridingEntity instanceof PlayerEntity && (playerEntity = (PlayerEntity)ridingEntity).func_184592_cb().func_77973_b() == ModItems.SKI_STICK_ITEM.get() && playerEntity.func_184614_ca().func_77973_b() == ModItems.SKI_STICK_ITEM.get();
    }

    private void updateMotion() {
        float momentum = 0.25f;
        double falling = this.func_189652_ae() ? 0.0 : -0.02;
        switch (this.status) {
            case IN_WATER: {
                momentum = 0.2f;
                break;
            }
            case ON_LAND: {
                momentum = 0.4f;
                break;
            }
            case ON_SNOW: {
                momentum = this.isHoldingSkiSticks(this.func_184179_bs()) ? 0.92f : 0.85f;
                break;
            }
            case IN_AIR: {
                momentum = (Boolean)this.field_70180_af.func_187225_a(FLYING) != false ? 0.9f : 0.85f;
                break;
            }
            default: {
                momentum = 0.4f;
            }
        }
        Vector3d motion = this.func_213322_ci();
        motion = motion.func_72441_c(0.0, falling, 0.0);
        motion = (Boolean)this.field_70180_af.func_187225_a(FLYING) != false ? new Vector3d(motion.field_72450_a, Math.max(motion.field_72448_b + falling, -0.03), motion.field_72449_c) : motion.func_72441_c(0.0, falling, 0.0);
        motion = motion.func_216372_d((double)momentum, 1.0, (double)momentum);
        this.func_213317_d(motion);
        this.deltaRotation *= momentum;
    }

    public void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown, boolean boostDown, boolean flyDown) {
        this.leftInputDown = leftInputDown;
        this.rightInputDown = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
        this.boostDown = boostDown;
        this.flyDown = flyDown;
    }

    private void updateStatus() {
        BlockState blockState = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        if (blockState.func_196958_f()) {
            blockState = this.field_70170_p.func_180495_p(this.func_226270_aj_());
        }
        this.status = this.func_70090_H() ? Status.IN_WATER : (blockState.func_196958_f() ? Status.IN_AIR : (ModTags.Blocks.SNOWY_BLOCKS.func_230235_a_((Object)blockState.func_177230_c()) ? Status.ON_SNOW : Status.ON_LAND));
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean isCreative;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = isCreative = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (isCreative || this.getDamageTaken() > 40.0f) {
                if (!isCreative && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    ItemStack stack = new ItemStack((IItemProvider)ModItems.SKIS_ITEM.get());
                    ((SkisItem)stack.func_77973_b()).setSkisType(stack, this.getSkisType().name());
                    this.func_199701_a_(stack);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    protected void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    private void setForwardDirection(int forward) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forward);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    private void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public void setSkisType(SkisType type) {
        this.field_70180_af.func_187227_b(SKIS_TYPE, (Object)type.ordinal());
    }

    @Nonnull
    public SkisType getSkisType() {
        SkisType[] types = SkisType.values();
        int type = (Integer)this.field_70180_af.func_187225_a(SKIS_TYPE);
        if (type < 0 || type >= types.length) {
            return SkisType.ACACIA;
        }
        return types[type];
    }

    public boolean func_241849_j(Entity entity) {
        return SkisEntity.checkCollisionWithEntity(this, entity);
    }

    private static boolean checkCollisionWithEntity(Entity ridingEntity, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !ridingEntity.func_184223_x(entity);
    }

    @Nonnull
    protected Vector3d func_241839_a(@Nonnull Direction.Axis axis, @Nonnull TeleportationRepositioner.Result result) {
        return LivingEntity.func_242288_h((Vector3d)super.func_241839_a(axis, result));
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof SkisEntity) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return 0.45;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Nonnull
    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    private void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74778_a("Type", this.getSkisType().name());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("Type", 8)) {
            this.setSkisType(SkisType.valueOf(nbt.func_74779_i("Type")));
        }
    }

    private static enum Status {
        IN_WATER,
        ON_SNOW,
        ON_LAND,
        IN_AIR;

    }

    public static enum SkisType {
        ACACIA(Items.field_221590_r, new ResourceLocation("minecraft", "textures/block/acacia_planks.png")),
        BIRCH(Items.field_221588_p, new ResourceLocation("minecraft", "textures/block/birch_planks.png")),
        CRIMSON(Items.field_234798_v_, new ResourceLocation("minecraft", "textures/block/crimson_planks.png")),
        DARK_OAK(Items.field_221591_s, new ResourceLocation("minecraft", "textures/block/dark_oak_planks.png")),
        JUNGLE(Items.field_221589_q, new ResourceLocation("minecraft", "textures/block/jungle_planks.png")),
        OAK(Items.field_221586_n, new ResourceLocation("minecraft", "textures/block/oak_planks.png")),
        SPRUCE(Items.field_221587_o, new ResourceLocation("minecraft", "textures/block/spruce_planks.png")),
        WARPED(Items.field_234799_w_, new ResourceLocation("minecraft", "textures/block/warped_planks.png"));

        public final Item item = (Item)ModItems.SKIS_ITEM.get();
        public final Item material;
        public final ResourceLocation texture;

        private SkisType(Item material, ResourceLocation texture) {
            this.material = material;
            this.texture = texture;
        }

        public static SkisType getRandom() {
            return SkisType.values()[(int)(Math.random() * (double)SkisType.values().length)];
        }
    }
}

