/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.skiing.core;

import com.affehund.skiing.client.render.SkisRenderer;
import com.affehund.skiing.common.entity.SkisEntity;
import com.affehund.skiing.common.item.PulloverItem;
import com.affehund.skiing.common.item.SkisItem;
import com.affehund.skiing.common.item.SnowShovel;
import com.affehund.skiing.core.data.gen.ModDataGeneration;
import com.affehund.skiing.core.init.ModBiomes;
import com.affehund.skiing.core.init.ModBlocks;
import com.affehund.skiing.core.init.ModEntities;
import com.affehund.skiing.core.init.ModItemGroup;
import com.affehund.skiing.core.init.ModItems;
import com.affehund.skiing.core.init.ModPaintings;
import com.affehund.skiing.core.init.ModTileEntities;
import com.affehund.skiing.core.init.ModVillagers;
import com.affehund.skiing.core.utils.SnowShovelUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="skiing")
public class SkiingMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static SkiingMod INSTANCE;
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    public SkiingMod() {
        LOGGER.debug("Loading up Affehund's Skiing Mod!");
        this.modEventBus.addListener(this::commonSetup);
        this.modEventBus.addListener(this::clientSetup);
        this.modEventBus.addListener(this::gatherData);
        ModBlocks.BLOCKS.register(this.modEventBus);
        ModItems.ITEMS.register(this.modEventBus);
        ModTileEntities.TILE_ENTITIES.register(this.modEventBus);
        ModEntities.ENTITIES.register(this.modEventBus);
        ModPaintings.PAINTINGS.register(this.modEventBus);
        ModVillagers.POINTS_OF_INTEREST.register(this.modEventBus);
        ModVillagers.PROFESSIONS.register(this.modEventBus);
        ModBiomes.BIOMES.register(this.modEventBus);
        ModBiomes.registerBiomes();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common setup!");
        event.enqueueWork(() -> ModVillagers.initVillagers());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client setup!");
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.SKI_ENTITY.get()), SkisRenderer::new);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            ModDataGeneration.BlockTagsGen blockTagsProvider = new ModDataGeneration.BlockTagsGen(generator, "skiing", existingFileHelper);
            generator.func_200390_a((IDataProvider)blockTagsProvider);
            generator.func_200390_a((IDataProvider)new ModDataGeneration.ItemTagsGen(generator, blockTagsProvider, "skiing", existingFileHelper));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.RecipeGen(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new ModDataGeneration.LanguageGen(generator, "skiing", "de_de"));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.LanguageGen(generator, "skiing", "en_us"));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.ItemModelGen(generator, "skiing", existingFileHelper));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.BlockStateGen(generator, "skiing", existingFileHelper));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void controllSkis(InputUpdateEvent event) {
        Entity riddenEntity;
        if (Minecraft.func_71410_x().field_71439_g != null && (riddenEntity = Minecraft.func_71410_x().field_71439_g.func_184187_bx()) instanceof SkisEntity) {
            MovementInput movementInput = event.getMovementInput();
            ((SkisEntity)riddenEntity).updateInputs(movementInput.field_187257_e, movementInput.field_187258_f, movementInput.field_187255_c, movementInput.field_187256_d, Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d(), movementInput.field_78901_c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        ItemStack tool = player.func_184614_ca();
        if (!tool.func_190926_b() && tool.func_77973_b() instanceof SnowShovel) {
            int radius = SnowShovel.getRadius();
            ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            List<BlockPos> extraBlocks = SnowShovelUtils.getBlocksToBreak(world, (PlayerEntity)player, radius);
            BlockPos lookingAtPos = SnowShovelUtils.getLookingAtBlockRayTrace(world, (PlayerEntity)player).func_216350_a();
            WorldRenderer worldRender = event.getContext();
            MatrixStack matrix = event.getMatrix();
            IVertexBuilder vertexBuilder = worldRender.field_228415_m_.func_228487_b_().getBuffer(RenderType.func_228659_m_());
            Entity viewEntity = renderInfo.func_216773_g();
            Vector3d vector3d = renderInfo.func_216785_c();
            double d0 = vector3d.func_82615_a();
            double d1 = vector3d.func_82617_b();
            double d2 = vector3d.func_82616_c();
            matrix.func_227860_a_();
            if (tool.func_150998_b(world.func_180495_p(lookingAtPos))) {
                for (BlockPos pos : extraBlocks) {
                    BlockState state;
                    if (!world.func_175723_af().func_177746_a(pos) || !tool.func_150998_b(state = world.func_180495_p(pos))) continue;
                    worldRender.func_228429_a_(matrix, vertexBuilder, viewEntity, d0, d1, d2, pos, world.func_180495_p(pos));
                }
            }
            matrix.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ModBlocks.BLOCKS.getEntries().stream().filter(block -> !(block.get() instanceof FlowingFluidBlock)).map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(ModItemGroup.MOD_ITEM_GROUP);
            BlockItem blockItem = new BlockItem(block, properties);
            blockItem.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
            registry.register((IForgeRegistryEntry)blockItem);
        });
        LOGGER.debug("Registered block items!");
    }

    @SubscribeEvent
    public void onSetVillagerTrades(VillagerTradesEvent event) {
        List novice = (List)event.getTrades().get(1);
        List apprentice = (List)event.getTrades().get(2);
        List journeyman = (List)event.getTrades().get(3);
        List expert = (List)event.getTrades().get(4);
        List master = (List)event.getTrades().get(5);
        if (event.getType() == ModVillagers.SKIS_MERCHANT.get()) {
            novice.add(new BasicTrade(this.getRandomIntInRange(2, 4), this.randomPulloverStack(), 20, 10));
            novice.add(new BasicTrade(this.getRandomIntInRange(2, 4), this.randomPulloverStack(), 20, 10));
            novice.add(new BasicTrade(this.getRandomIntInRange(2, 4), new ItemStack((IItemProvider)ModItems.SNOW_SHOVEL.get()), 20, 10));
            apprentice.add(new BasicTrade(this.getRandomIntInRange(1, 3), this.randomSkisItemStack(), 20, 10));
            apprentice.add(new BasicTrade(this.getRandomIntInRange(1, 3), this.randomSkisItemStack(), 20, 10));
            apprentice.add(new BasicTrade(this.getRandomIntInRange(2, 4), new ItemStack((IItemProvider)ModItems.SKI_STICK_ITEM.get(), 2), 20, 10));
            journeyman.add(new BasicTrade(this.getRandomIntInRange(2, 4), new ItemStack((IItemProvider)ModItems.CHOCOLATE_CUP.get()), 20, 10));
            journeyman.add(new BasicTrade(this.randomPulloverStack(), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 20, 10, 1.0f));
            journeyman.add(new BasicTrade(this.randomPulloverStack(), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 20, 10, 1.0f));
            expert.add(new BasicTrade(new ItemStack((IItemProvider)ModItems.SKI_STICK_ITEM.get(), 2), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 20, 10, 1.0f));
            expert.add(new BasicTrade(this.randomSkisItemStack(), new ItemStack((IItemProvider)Items.field_151166_bC), 20, 10, 1.0f));
            expert.add(new BasicTrade(this.randomSkisItemStack(), new ItemStack((IItemProvider)Items.field_151166_bC), 20, 10, 1.0f));
            master.add(new BasicTrade(this.getRandomIntInRange(2, 4), new ItemStack((IItemProvider)Items.field_151126_ay, 16), 20, 10));
            master.add(new BasicTrade(this.getRandomIntInRange(3, 5), new ItemStack((IItemProvider)Items.field_221772_cv, 8), 20, 10));
            master.add(new BasicTrade(new ItemStack((IItemProvider)Items.field_221772_cv, 8), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 20, 10, 1.0f));
        }
    }

    private int getRandomIntInRange(int minimum, int maximum) {
        int number = minimum + new Random().nextInt(maximum - minimum + 1);
        return number;
    }

    private ItemStack randomPulloverStack() {
        ItemStack pulloverStack = new ItemStack((IItemProvider)ModItems.PULLOVER.get());
        ((PulloverItem)pulloverStack.func_77973_b()).func_200885_a(pulloverStack, DyeColor.values()[new Random().nextInt(DyeColor.values().length)].func_196060_f());
        return pulloverStack;
    }

    private ItemStack randomSkisItemStack() {
        ItemStack skisStack = new ItemStack((IItemProvider)ModItems.SKIS_ITEM.get());
        SkisEntity.SkisType type = SkisEntity.SkisType.getRandom();
        ((SkisItem)skisStack.func_77973_b()).setSkisType(skisStack, type.name());
        return skisStack;
    }
}

